/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import com.worksap.nlp.sudachi.dictionary.BinaryDictionary;
import com.worksap.nlp.sudachi.dictionary.DoubleArrayLexicon;
import com.worksap.nlp.sudachi.dictionary.GrammarImpl;
import com.worksap.nlp.sudachi.dictionary.WordInfo;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class DictionaryPrinter {
    private DictionaryPrinter() {
    }

    static void printDictionary(String filename, BinaryDictionary systemDict, PrintStream output) throws IOException {
        GrammarImpl grammar = null;
        try (BinaryDictionary dictionary = new BinaryDictionary(filename);){
            if (dictionary.getDictionaryHeader().getVersion() == 8315566796372513255L) {
                grammar = dictionary.getGrammar();
            } else {
                if (systemDict == null) {
                    throw new IllegalArgumentException("the system dictionary is not specified");
                }
                grammar = systemDict.getGrammar();
                if (dictionary.getDictionaryHeader().getVersion() == -6926899439371495320L) {
                    grammar.addPosList(dictionary.getGrammar());
                }
            }
            ArrayList<String> posStrings = new ArrayList<String>();
            for (short pid = 0; pid < grammar.getPartOfSpeechSize(); pid = (short)(pid + 1)) {
                posStrings.add(String.join((CharSequence)",", grammar.getPartOfSpeechString(pid)));
            }
            DoubleArrayLexicon lexicon = dictionary.getLexicon();
            for (int wordId = 0; wordId < lexicon.size(); ++wordId) {
                short leftId = lexicon.getLeftId(wordId);
                short rightId = lexicon.getRightId(wordId);
                short cost = lexicon.getCost(wordId);
                WordInfo wordInfo = lexicon.getWordInfo(wordId);
                char unitType = DictionaryPrinter.getUnitType(wordInfo);
                output.println(String.format("%s,%d,%d,%d,%s,%s,%s,%s,%s,%c,%s,%s,%s", wordInfo.getSurface(), leftId, rightId, cost, wordInfo.getSurface(), posStrings.get(wordInfo.getPOSId()), wordInfo.getReadingForm(), wordInfo.getNormalizedForm(), DictionaryPrinter.wordIdToString(wordInfo.getDictionaryFormWordId()), Character.valueOf(unitType), DictionaryPrinter.splitToString(wordInfo.getAunitSplit()), DictionaryPrinter.splitToString(wordInfo.getBunitSplit()), DictionaryPrinter.splitToString(wordInfo.getWordStructure())));
            }
        }
    }

    static String wordIdToString(int wid) {
        return wid < 0 ? "*" : Integer.toString(wid);
    }

    static char getUnitType(WordInfo info) {
        if (info.getAunitSplit().length == 0) {
            return 'A';
        }
        if (info.getBunitSplit().length == 0) {
            return 'B';
        }
        return 'C';
    }

    static String splitToString(int[] split) {
        if (split.length == 0) {
            return "*";
        }
        return Arrays.stream(split).mapToObj(i -> i >> 28 != 0 ? "U" + Integer.toString(i & 0xFFFFFFF) : Integer.toString(i)).collect(Collectors.joining("/"));
    }

    public static void main(String[] args) throws IOException {
        try (BinaryDictionary systemDict = null;){
            int i = 0;
            for (i = 0; i < args.length; ++i) {
                if (!args[i].equals("-s") || i + 1 >= args.length) {
                    if (!args[i].equals("-h")) break;
                    System.err.println("usage: PrintDictionary [-s file] file");
                    System.err.println("\t-s file\tsystem dictionary");
                    return;
                }
                systemDict = BinaryDictionary.readSystemDictionary(args[++i]);
            }
            if (i < args.length) {
                DictionaryPrinter.printDictionary(args[i], systemDict, System.out);
            }
        }
    }
}

