/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import com.worksap.nlp.sudachi.dictionary.DictionaryHeader;
import com.worksap.nlp.sudachi.dictionary.DictionaryVersion;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.time.Instant;
import java.time.ZoneId;

public class DictionaryHeaderPrinter {
    private DictionaryHeaderPrinter() {
    }

    static void printHeader(String filename, PrintStream output) throws IOException {
        MappedByteBuffer bytes;
        try (FileInputStream input = new FileInputStream(filename);
             FileChannel inputFile = input.getChannel();){
            bytes = inputFile.map(FileChannel.MapMode.READ_ONLY, 0L, inputFile.size());
            bytes.order(ByteOrder.LITTLE_ENDIAN);
        }
        DictionaryHeader header = new DictionaryHeader(bytes, 0);
        output.println("filename: " + filename);
        long version = header.getVersion();
        if (version == 8315566796372513255L) {
            output.println("type: system dictionary");
        } else if (DictionaryVersion.isUserDictionary(version)) {
            output.println("type: user dictionary");
        } else {
            output.println("invalid file");
            return;
        }
        output.println("createTime: " + Instant.ofEpochSecond(header.getCreateTime()).atZone(ZoneId.systemDefault()).toString());
        output.println("description: " + header.getDescription());
    }

    public static void main(String[] args) throws IOException {
        for (String filename : args) {
            DictionaryHeaderPrinter.printHeader(filename, System.out);
        }
    }
}

