/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import com.worksap.nlp.sudachi.MMap;
import com.worksap.nlp.sudachi.dictionary.DictionaryHeader;
import com.worksap.nlp.sudachi.dictionary.DictionaryVersion;
import com.worksap.nlp.sudachi.dictionary.DoubleArrayLexicon;
import com.worksap.nlp.sudachi.dictionary.GrammarImpl;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;

public class BinaryDictionary
implements Closeable {
    private ByteBuffer bytes;
    private DictionaryHeader header;
    private GrammarImpl grammar;
    private DoubleArrayLexicon lexicon;

    BinaryDictionary(String fileName) throws IOException {
        this.bytes = MMap.map(fileName);
        int offset = 0;
        this.header = new DictionaryHeader(this.bytes, offset);
        offset += this.header.storageSize();
        long version = this.header.getVersion();
        if (version == 8315566796372513255L || version == -6926899439371495320L) {
            this.grammar = new GrammarImpl(this.bytes, offset);
            offset += this.grammar.storageSize();
        } else if (version == -6552964951306006041L) {
            this.grammar = new GrammarImpl();
        } else {
            MMap.unmap(this.bytes);
            throw new IOException("invalid dictionary");
        }
        this.lexicon = new DoubleArrayLexicon(this.bytes, offset);
    }

    public static BinaryDictionary readSystemDictionary(String fileName) throws IOException {
        BinaryDictionary dict = new BinaryDictionary(fileName);
        if (dict.getDictionaryHeader().getVersion() != 8315566796372513255L) {
            dict.close();
            throw new IOException("invalid system dictionary");
        }
        return dict;
    }

    public static BinaryDictionary readUserDictionary(String fileName) throws IOException {
        BinaryDictionary dict = new BinaryDictionary(fileName);
        if (!DictionaryVersion.isUserDictionary(dict.getDictionaryHeader().getVersion())) {
            dict.close();
            throw new IOException("invalid user dictionary");
        }
        return dict;
    }

    @Override
    public void close() throws IOException {
        MMap.unmap(this.bytes);
    }

    public DictionaryHeader getDictionaryHeader() {
        return this.header;
    }

    public GrammarImpl getGrammar() {
        return this.grammar;
    }

    public DoubleArrayLexicon getLexicon() {
        return this.lexicon;
    }
}

