/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.InputTextBuilder;
import com.worksap.nlp.sudachi.UTF8InputText;
import com.worksap.nlp.sudachi.dictionary.CategoryType;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

class UTF8InputTextBuilder
implements InputTextBuilder {
    private final String originalText;
    private StringBuilder modifiedText;
    private List<Integer> modifiedToOriginal;
    private final Grammar grammar;

    public UTF8InputTextBuilder(CharSequence text, Grammar grammar) {
        this.grammar = grammar;
        this.originalText = text.toString();
        this.modifiedText = new StringBuilder(text);
        this.modifiedToOriginal = new ArrayList<Integer>(this.modifiedText.length() + 1);
        int j = 0;
        for (int i = 0; i < this.originalText.length(); ++i) {
            if (!Character.isLowSurrogate(this.originalText.charAt(i))) {
                j = i;
            }
            this.modifiedToOriginal.add(j);
        }
        this.modifiedToOriginal.add(this.originalText.length());
    }

    @Override
    public void replace(int begin, int end, String str) {
        if (begin < 0) {
            throw new StringIndexOutOfBoundsException(begin);
        }
        if (begin > this.modifiedText.length()) {
            throw new StringIndexOutOfBoundsException("begin > length()");
        }
        if (begin > end) {
            throw new StringIndexOutOfBoundsException("begin > end");
        }
        if (begin == end) {
            throw new IllegalArgumentException("begin == end");
        }
        if (end > this.modifiedText.length()) {
            end = this.modifiedText.length();
        }
        this.modifiedText.replace(begin, end, str);
        int modifiedBegin = this.modifiedToOriginal.get(begin);
        int modifiedEnd = this.modifiedToOriginal.get(end);
        int length = str.length();
        if (end - begin > length) {
            this.modifiedToOriginal.subList(begin + length, end).clear();
        }
        this.modifiedToOriginal.set(begin, modifiedBegin);
        for (int i = 1; i < length; ++i) {
            if (begin + i < end) {
                this.modifiedToOriginal.set(begin + i, modifiedEnd);
                continue;
            }
            this.modifiedToOriginal.add(begin + i, modifiedEnd);
        }
    }

    @Override
    public String getOriginalText() {
        return this.originalText;
    }

    @Override
    public String getText() {
        return this.modifiedText.toString();
    }

    @Override
    public UTF8InputText build() {
        String modifiedStringText = this.getText();
        byte[] byteText = modifiedStringText.getBytes(StandardCharsets.UTF_8);
        int length = byteText.length;
        int[] byteToModified = new int[length + 1];
        int[] byteToOriginal = new int[length + 1];
        int j = 0;
        for (int i = 0; i < this.modifiedText.length(); ++i) {
            if (Character.isLowSurrogate(this.modifiedText.charAt(i))) continue;
            for (int k = 0; k < this.utf8ByteLength(this.modifiedText.codePointAt(i)); ++k) {
                byteToModified[j] = i;
                byteToOriginal[j] = this.modifiedToOriginal.get(i);
                ++j;
            }
        }
        byteToModified[length] = modifiedStringText.length();
        byteToOriginal[length] = this.modifiedToOriginal.get(this.modifiedToOriginal.size() - 1);
        List<EnumSet<CategoryType>> charCategories = this.getCharCategoryTypes(modifiedStringText);
        List<Integer> charCategoryContinuities = this.getCharCategoryContinuities(modifiedStringText, length, charCategories);
        List<Boolean> canBowList = this.buildCanBowList(modifiedStringText, charCategories);
        return new UTF8InputText(this.grammar, this.originalText, modifiedStringText, byteText, byteToOriginal, byteToModified, Collections.unmodifiableList(this.modifiedToOriginal), Collections.unmodifiableList(charCategories), charCategoryContinuities, Collections.unmodifiableList(canBowList));
    }

    private List<EnumSet<CategoryType>> getCharCategoryTypes(String text) {
        if (text.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EnumSet<CategoryType>> charCategoryTypes = new ArrayList<EnumSet<CategoryType>>(text.length());
        EnumSet<CategoryType> types = null;
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isLowSurrogate(text.charAt(i)) && types != null) {
                charCategoryTypes.add(types);
                continue;
            }
            types = this.grammar.getCharacterCategory().getCategoryTypes(text.codePointAt(i));
            charCategoryTypes.add(types);
        }
        return charCategoryTypes;
    }

    private List<Integer> getCharCategoryContinuities(String text, int byteLength, List<EnumSet<CategoryType>> charCategories) {
        if (text.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> charCategoryContinuities = new ArrayList<Integer>(byteLength);
        int i = 0;
        while (i < charCategories.size()) {
            int next = i + this.getCharCategoryContinuousLength(charCategories, i);
            int length = 0;
            int j = i;
            while (j < next) {
                length += this.utf8ByteLength(text.codePointAt(j));
                j = text.offsetByCodePoints(j, 1);
            }
            for (int k = length; k > 0; --k) {
                charCategoryContinuities.add(k);
            }
            i = next;
        }
        return charCategoryContinuities;
    }

    private int getCharCategoryContinuousLength(List<EnumSet<CategoryType>> charCategories, int offset) {
        int length;
        Object continuousCategory = charCategories.get(offset).clone();
        for (length = 1; length < charCategories.size() - offset; ++length) {
            continuousCategory.retainAll((Collection)charCategories.get(offset + length));
            if (!continuousCategory.isEmpty()) continue;
            return length;
        }
        return length;
    }

    private List<Boolean> buildCanBowList(String text, List<EnumSet<CategoryType>> charCategories) {
        if (text.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Boolean> canBowList = new ArrayList<Boolean>(text.length());
        for (int i = 0; i < charCategories.size(); ++i) {
            if (i == 0) {
                canBowList.add(true);
                continue;
            }
            if (Character.isLowSurrogate(text.charAt(i))) {
                canBowList.add(false);
                continue;
            }
            Object types = charCategories.get(i).clone();
            if (((AbstractCollection)types).contains((Object)CategoryType.ALPHA) || ((AbstractCollection)types).contains((Object)CategoryType.GREEK) || ((AbstractCollection)types).contains((Object)CategoryType.CYRILLIC)) {
                ((AbstractCollection)types).retainAll((Collection)charCategories.get(i - 1));
                canBowList.add(((AbstractCollection)types).isEmpty());
                continue;
            }
            canBowList.add(true);
        }
        return canBowList;
    }

    private int utf8ByteLength(int cp) {
        if (cp < 0) {
            return 0;
        }
        if (cp <= 127) {
            return 1;
        }
        if (cp <= 2047) {
            return 2;
        }
        if (cp <= 65535) {
            return 3;
        }
        if (cp <= 0x10FFFF) {
            return 4;
        }
        return 0;
    }
}

