/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.InputText;
import com.worksap.nlp.sudachi.dictionary.CategoryType;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

class UTF8InputText
implements InputText {
    private final String originalText;
    private final String modifiedText;
    private final byte[] bytes;
    private final int[] byteToOriginal;
    private final int[] byteToModified;
    private final List<Integer> modifiedToOriginal;
    private final List<EnumSet<CategoryType>> charCategories;
    private final List<Integer> charCategoryContinuities;
    private final List<Boolean> canBowList;

    UTF8InputText(Grammar grammar, String originalText, String modifiedText, byte[] bytes, int[] byteToOriginal, int[] byteToModified, List<Integer> modifiedToOriginal, List<EnumSet<CategoryType>> charCategories, List<Integer> charCategoryContinuities, List<Boolean> canBowList) {
        this.originalText = originalText;
        this.modifiedText = modifiedText;
        this.bytes = bytes;
        this.byteToOriginal = byteToOriginal;
        this.byteToModified = byteToModified;
        this.modifiedToOriginal = modifiedToOriginal;
        this.charCategories = charCategories;
        this.charCategoryContinuities = charCategoryContinuities;
        this.canBowList = canBowList;
    }

    @Override
    public String getOriginalText() {
        return this.originalText;
    }

    @Override
    public String getText() {
        return this.modifiedText;
    }

    byte[] getByteText() {
        return this.bytes;
    }

    @Override
    public String getSubstring(int begin, int end) {
        if (begin < 0) {
            throw new StringIndexOutOfBoundsException(begin);
        }
        if (end > this.bytes.length) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (begin > end) {
            throw new StringIndexOutOfBoundsException(end - begin);
        }
        return this.modifiedText.substring(this.byteToModified[begin], this.byteToModified[end]);
    }

    @Override
    public UTF8InputText slice(int begin, int end) {
        if (begin < 0) {
            throw new StringIndexOutOfBoundsException(begin);
        }
        if (end > this.modifiedText.length()) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (begin > end) {
            throw new StringIndexOutOfBoundsException(end - begin);
        }
        int byteBegin = this.getCodePointsOffsetLength(0, begin);
        int length = this.getCodePointsOffsetLength(byteBegin, end - begin);
        int byteEnd = byteBegin + length;
        String originalText = this.originalText.substring(this.byteToOriginal[byteBegin], this.byteToOriginal[byteEnd]);
        String modifiedText = this.modifiedText.substring(begin, end);
        byte[] bytes = Arrays.copyOfRange(this.bytes, byteBegin, byteEnd);
        int[] byteToOriginal = new int[length + 1];
        for (int i = 0; i < length + 1; ++i) {
            byteToOriginal[i] = this.byteToOriginal[byteBegin + i] - this.byteToOriginal[byteBegin];
        }
        int[] byteToModified = new int[length + 1];
        for (int i = 0; i < length + 1; ++i) {
            byteToModified[i] = this.byteToModified[byteBegin + i] - begin;
        }
        ArrayList<Integer> modifiedToOriginal = new ArrayList<Integer>();
        for (int i = 0; i < end + 1; ++i) {
            modifiedToOriginal.add(this.modifiedToOriginal.get(i) - this.modifiedToOriginal.get(begin));
        }
        List<EnumSet<CategoryType>> charCategories = this.charCategories.subList(begin, end);
        List<Integer> charCategoryContinuities = this.charCategoryContinuities.subList(byteBegin, byteEnd);
        if (charCategoryContinuities.get(length - 1) != 1) {
            int i = length - 1;
            int len = 1;
            while (i >= 0 && charCategoryContinuities.get(i) != 1) {
                charCategoryContinuities.set(i--, len++);
            }
        }
        List<Boolean> canBowList = this.canBowList.subList(begin, end);
        return new UTF8InputText(null, originalText, modifiedText, bytes, byteToOriginal, byteToModified, modifiedToOriginal, charCategories, charCategoryContinuities, canBowList);
    }

    int getOffsetTextLength(int index) {
        return this.byteToModified[index];
    }

    @Override
    public int getOriginalIndex(int index) {
        return this.byteToOriginal[index];
    }

    @Override
    public Set<CategoryType> getCharCategoryTypes(int index) {
        return this.charCategories.get(this.byteToModified[index]);
    }

    @Override
    public Set<CategoryType> getCharCategoryTypes(int begin, int end) {
        if (begin + this.getCharCategoryContinuousLength(begin) < end) {
            return Collections.emptySet();
        }
        int b = this.byteToModified[begin];
        int e = this.byteToModified[end];
        Object continuousCategory = this.charCategories.get(b).clone();
        for (int i = b + 1; i < e; ++i) {
            continuousCategory.retainAll((Collection)this.charCategories.get(i));
        }
        return continuousCategory;
    }

    @Override
    public int getCharCategoryContinuousLength(int index) {
        return this.charCategoryContinuities.get(index);
    }

    @Override
    public int getCodePointsOffsetLength(int index, int codePointOffset) {
        int length = 0;
        int target = this.byteToModified[index] + codePointOffset;
        for (int i = index; i < this.bytes.length; ++i) {
            if (this.byteToModified[i] >= target) {
                return length;
            }
            ++length;
        }
        return length;
    }

    @Override
    public int codePointCount(int begin, int end) {
        return this.byteToModified[end] - this.byteToModified[begin];
    }

    @Override
    public boolean canBow(int index) {
        return this.isCharAlignment(index) && this.canBowList.get(this.byteToModified[index]) != false;
    }

    @Override
    public int getWordCandidateLength(int index) {
        for (int i = index + 1; i < this.bytes.length; ++i) {
            if (!this.canBow(i)) continue;
            return i - index;
        }
        return this.bytes.length - index;
    }

    private boolean isCharAlignment(int index) {
        return (this.bytes[index] & 0xC0) != 128;
    }

    @Override
    public int getNextInOriginal(int index) {
        int o = this.modifiedToOriginal.get(index + 1);
        while (index + 1 < this.modifiedText.length() + 1 && this.modifiedToOriginal.get(index + 1) == o) {
            ++index;
        }
        return index;
    }

    int textIndexToOriginalTextIndex(int index) {
        return this.modifiedToOriginal.get(index);
    }
}

