/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.InputText;
import com.worksap.nlp.sudachi.Lattice;
import com.worksap.nlp.sudachi.LatticeNode;
import com.worksap.nlp.sudachi.Plugin;
import com.worksap.nlp.sudachi.dictionary.CategoryType;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import com.worksap.nlp.sudachi.dictionary.WordInfo;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public abstract class PathRewritePlugin
extends Plugin {
    public void setUp(Grammar grammar) throws IOException {
    }

    public abstract void rewrite(InputText var1, List<LatticeNode> var2, Lattice var3);

    public LatticeNode concatenate(List<LatticeNode> path, int begin, int end, Lattice lattice, String normalizedForm) {
        if (begin >= end) {
            throw new IndexOutOfBoundsException("begin >= end");
        }
        int b = path.get(begin).getBegin();
        int e = path.get(end - 1).getEnd();
        short posId = path.get(begin).getWordInfo().getPOSId();
        StringBuilder surface = new StringBuilder();
        int length = 0;
        StringBuilder normalizedFormBuilder = new StringBuilder();
        StringBuilder dictionaryForm = new StringBuilder();
        StringBuilder readingForm = new StringBuilder();
        for (int i = begin; i < end; ++i) {
            WordInfo info = path.get(i).getWordInfo();
            surface.append(info.getSurface());
            length += info.getLength();
            if (normalizedForm == null) {
                normalizedFormBuilder.append(info.getNormalizedForm());
            }
            dictionaryForm.append(info.getDictionaryForm());
            readingForm.append(info.getReadingForm());
        }
        WordInfo wi = new WordInfo(surface.toString(), (short)length, posId, normalizedForm == null ? normalizedFormBuilder.toString() : normalizedForm, dictionaryForm.toString(), readingForm.toString());
        LatticeNode node = lattice.createNode();
        node.setRange(b, e);
        node.setWordInfo(wi);
        this.replaceNode(path, begin, end, node);
        return node;
    }

    public LatticeNode concatenateOov(List<LatticeNode> path, int begin, int end, short posId, Lattice lattice) {
        int e;
        if (begin >= end) {
            throw new IndexOutOfBoundsException("begin >= end");
        }
        int b = path.get(begin).getBegin();
        Optional<? extends LatticeNode> n = lattice.getMinimumNode(b, e = path.get(end - 1).getEnd());
        if (n.isPresent()) {
            LatticeNode node = n.get();
            this.replaceNode(path, begin, end, node);
            return node;
        }
        StringBuilder surface = new StringBuilder();
        int length = 0;
        for (int i = begin; i < end; ++i) {
            WordInfo info = path.get(i).getWordInfo();
            surface.append(info.getSurface());
            length += info.getLength();
        }
        String s = surface.toString();
        WordInfo wi = new WordInfo(s, (short)length, posId, s, s, "");
        LatticeNode node = lattice.createNode();
        node.setRange(b, e);
        node.setWordInfo(wi);
        node.setOOV();
        this.replaceNode(path, begin, end, node);
        return node;
    }

    public Set<CategoryType> getCharCategoryTypes(InputText text, LatticeNode node) {
        return text.getCharCategoryTypes(node.getBegin(), node.getEnd());
    }

    private void replaceNode(List<LatticeNode> path, int begin, int end, LatticeNode node) {
        path.subList(begin, end).clear();
        path.add(begin, node);
    }
}

