/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.LatticeNode;
import com.worksap.nlp.sudachi.dictionary.Lexicon;
import com.worksap.nlp.sudachi.dictionary.WordInfo;

public class LatticeNodeImpl
implements LatticeNode {
    int begin;
    int end;
    short leftId;
    short rightId;
    short cost;
    int wordId;
    int totalCost;
    LatticeNodeImpl bestPreviousNode;
    boolean isConnectedToBOS;
    boolean isDefined;
    boolean isOOV;
    WordInfo extraWordInfo;
    Lexicon lexicon;
    static final String NULL_SURFACE = "(null)";
    static final WordInfo UNDEFINED_WORDINFO = new WordInfo("(null)", 0, -1, "(null)", "(null)", "(null)");

    LatticeNodeImpl(Lexicon lexicon, short leftId, short rightId, short cost, int wordId) {
        this.lexicon = lexicon;
        this.leftId = leftId;
        this.rightId = rightId;
        this.cost = cost;
        this.wordId = wordId;
        this.isDefined = true;
    }

    LatticeNodeImpl() {
        this.isDefined = false;
    }

    @Override
    public void setParameter(short leftId, short rightId, short cost) {
        this.leftId = leftId;
        this.rightId = rightId;
        this.cost = cost;
    }

    @Override
    public int getBegin() {
        return this.begin;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public void setRange(int begin, int end) {
        this.begin = begin;
        this.end = end;
    }

    @Override
    public boolean isOOV() {
        return this.isOOV;
    }

    @Override
    public void setOOV() {
        this.isOOV = true;
    }

    @Override
    public WordInfo getWordInfo() {
        if (!this.isDefined) {
            return UNDEFINED_WORDINFO;
        }
        if (this.extraWordInfo != null) {
            return this.extraWordInfo;
        }
        return this.lexicon.getWordInfo(this.wordId);
    }

    @Override
    public void setWordInfo(WordInfo wordInfo) {
        this.extraWordInfo = wordInfo;
        this.isDefined = true;
    }

    @Override
    public int getPathCost() {
        return this.cost;
    }

    @Override
    public int getWordId() {
        return this.wordId;
    }

    @Override
    public int getDictionaryId() {
        if (!this.isDefined || this.extraWordInfo != null) {
            return -1;
        }
        return this.lexicon.getDictionaryId(this.wordId);
    }

    public String toString() {
        WordInfo wi = this.getWordInfo();
        String surface = wi.getSurface();
        short pos = wi.getPOSId();
        return String.format("%d %d %s(%d) %d %d %d %d", this.getBegin(), this.getEnd(), surface, this.wordId, pos, this.leftId, this.rightId, this.cost);
    }
}

