/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.Lattice;
import com.worksap.nlp.sudachi.LatticeNode;
import com.worksap.nlp.sudachi.LatticeNodeImpl;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import com.worksap.nlp.sudachi.dictionary.WordInfo;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

class LatticeImpl
implements Lattice {
    private ArrayList<List<LatticeNodeImpl>> endLists;
    private int size;
    private int capacity;
    private LatticeNodeImpl eosNode;
    private Grammar grammar;
    private short[] eosParams;

    LatticeImpl(Grammar grammar) {
        this.grammar = grammar;
        this.eosParams = grammar.getEOSParameter();
        this.endLists = new ArrayList();
        LatticeNodeImpl bosNode = new LatticeNodeImpl();
        short[] bosParams = grammar.getBOSParameter();
        bosNode.setParameter(bosParams[0], bosParams[1], bosParams[2]);
        bosNode.isConnectedToBOS = true;
        this.endLists.add(Collections.singletonList(bosNode));
    }

    void resize(int size) {
        if (size > this.capacity) {
            this.expand(size);
        }
        this.size = size;
        this.eosNode = new LatticeNodeImpl();
        this.eosNode.setParameter(this.eosParams[0], this.eosParams[1], this.eosParams[2]);
        this.eosNode.begin = this.eosNode.end = size;
    }

    void clear() {
        for (int i = 1; i < this.size + 1; ++i) {
            this.endLists.get(i).clear();
        }
        this.size = 0;
        this.eosNode = null;
    }

    void expand(int newSize) {
        this.endLists.ensureCapacity(newSize + 1);
        for (int i = this.size + 1; i < newSize + 1; ++i) {
            this.endLists.add(new ArrayList());
        }
        this.capacity = newSize;
    }

    public List<LatticeNodeImpl> getNodesWithEnd(int end) {
        return this.endLists.get(end);
    }

    public List<LatticeNodeImpl> getNodes(int begin, int end) {
        return this.endLists.get(end).stream().filter(n -> n.getBegin() == begin).collect(Collectors.toList());
    }

    public Optional<LatticeNodeImpl> getMinimumNode(int begin, int end) {
        return this.endLists.get(end).stream().filter(n -> n.getBegin() == begin).min((l, r) -> l.cost - r.cost);
    }

    @Override
    public void insert(int begin, int end, LatticeNode node) {
        LatticeNodeImpl n = (LatticeNodeImpl)node;
        this.endLists.get(end).add(n);
        n.begin = begin;
        n.end = end;
        this.connectNode(n);
    }

    @Override
    public void remove(int begin, int end, LatticeNode node) {
        this.endLists.get(end).remove(node);
    }

    @Override
    public LatticeNode createNode() {
        return new LatticeNodeImpl();
    }

    boolean hasPreviousNode(int index) {
        return !this.endLists.get(index).isEmpty();
    }

    void connectNode(LatticeNodeImpl rNode) {
        int begin = rNode.begin;
        rNode.totalCost = Integer.MAX_VALUE;
        for (LatticeNodeImpl lNode : this.endLists.get(begin)) {
            int cost;
            short connectCost;
            if (!lNode.isConnectedToBOS || (connectCost = this.grammar.getConnectCost(lNode.rightId, rNode.leftId)) == Short.MAX_VALUE || (cost = lNode.totalCost + connectCost) >= rNode.totalCost) continue;
            rNode.totalCost = cost;
            rNode.bestPreviousNode = lNode;
        }
        rNode.isConnectedToBOS = rNode.bestPreviousNode != null;
        rNode.totalCost += rNode.cost;
    }

    void connectEosNode() {
        this.connectNode(this.eosNode);
    }

    List<LatticeNode> getBestPath() {
        if (!this.eosNode.isConnectedToBOS) {
            throw new IllegalStateException("EOS isn't connected to BOS");
        }
        ArrayList<LatticeNode> result = new ArrayList<LatticeNode>();
        LatticeNodeImpl node = this.eosNode.bestPreviousNode;
        while (node != this.endLists.get(0).get(0)) {
            result.add(node);
            node = node.bestPreviousNode;
        }
        Collections.reverse(result);
        return result;
    }

    void dump(PrintStream output) {
        int index = 0;
        for (int i = this.size + 1; i >= 0; --i) {
            List<LatticeNodeImpl> rNodes = i <= this.size ? this.endLists.get(i) : Collections.singletonList(this.eosNode);
            for (LatticeNodeImpl rNode : rNodes) {
                String pos;
                String surface;
                if (!rNode.isDefined) {
                    surface = "(null)";
                    pos = "BOS/EOS";
                } else {
                    WordInfo wi = rNode.getWordInfo();
                    surface = wi.getSurface();
                    short posId = wi.getPOSId();
                    pos = posId < 0 ? "(null)" : String.join((CharSequence)",", this.grammar.getPartOfSpeechString(posId));
                }
                output.print(String.format("%d: %d %d %s(%d) %s %d %d %d: ", index, rNode.getBegin(), rNode.getEnd(), surface, rNode.wordId, pos, rNode.leftId, rNode.rightId, rNode.cost));
                ++index;
                for (LatticeNodeImpl lNode : this.endLists.get(rNode.begin)) {
                    short cost = this.grammar.getConnectCost(lNode.rightId, rNode.leftId);
                    output.print(String.format("%d ", cost));
                }
                output.println();
            }
        }
    }
}

