/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.Dictionary;
import com.worksap.nlp.sudachi.EditConnectionCostPlugin;
import com.worksap.nlp.sudachi.InputTextPlugin;
import com.worksap.nlp.sudachi.JapaneseTokenizer;
import com.worksap.nlp.sudachi.OovProviderPlugin;
import com.worksap.nlp.sudachi.PathRewritePlugin;
import com.worksap.nlp.sudachi.Settings;
import com.worksap.nlp.sudachi.SudachiCommandLine;
import com.worksap.nlp.sudachi.Tokenizer;
import com.worksap.nlp.sudachi.dictionary.BinaryDictionary;
import com.worksap.nlp.sudachi.dictionary.CharacterCategory;
import com.worksap.nlp.sudachi.dictionary.DoubleArrayLexicon;
import com.worksap.nlp.sudachi.dictionary.GrammarImpl;
import com.worksap.nlp.sudachi.dictionary.LexiconSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class JapaneseDictionary
implements Dictionary {
    GrammarImpl grammar;
    LexiconSet lexicon;
    List<InputTextPlugin> inputTextPlugins;
    List<OovProviderPlugin> oovProviderPlugins;
    List<PathRewritePlugin> pathRewritePlugins;
    List<BinaryDictionary> dictionaries;

    JapaneseDictionary() throws IOException {
        this(null, null, false);
    }

    JapaneseDictionary(String jsonString) throws IOException {
        this(null, jsonString, false);
    }

    JapaneseDictionary(String path, String jsonString, boolean mergeSettings) throws IOException {
        Settings settings = this.buildSettings(path, jsonString, mergeSettings);
        this.dictionaries = new ArrayList<BinaryDictionary>();
        this.readSystemDictionary(settings.getPath("systemDict"));
        for (EditConnectionCostPlugin editConnectionCostPlugin : settings.getPluginList("editConnectionCostPlugin")) {
            editConnectionCostPlugin.setUp(this.grammar);
            editConnectionCostPlugin.edit(this.grammar);
        }
        this.readCharacterDefinition(settings.getPath("characterDefinitionFile"));
        this.inputTextPlugins = settings.getPluginList("inputTextPlugin");
        for (InputTextPlugin inputTextPlugin : this.inputTextPlugins) {
            inputTextPlugin.setUp();
        }
        this.oovProviderPlugins = settings.getPluginList("oovProviderPlugin");
        if (this.oovProviderPlugins.isEmpty()) {
            throw new IllegalArgumentException("no OOV provider");
        }
        for (OovProviderPlugin oovProviderPlugin : this.oovProviderPlugins) {
            oovProviderPlugin.setUp(this.grammar);
        }
        this.pathRewritePlugins = settings.getPluginList("pathRewritePlugin");
        for (PathRewritePlugin pathRewritePlugin : this.pathRewritePlugins) {
            pathRewritePlugin.setUp(this.grammar);
        }
        for (String string : settings.getPathList("userDict")) {
            this.readUserDictionary(string);
        }
    }

    Settings buildSettings(String path, String jsonString, boolean mergeSettings) throws IOException {
        Settings defaultSettings;
        try (InputStream input = SudachiCommandLine.class.getResourceAsStream("/sudachi.json");){
            defaultSettings = Settings.parseSettings(path, JapaneseDictionary.readAll(input));
        }
        if (jsonString == null) {
            return defaultSettings;
        }
        if (mergeSettings) {
            defaultSettings.merge(Settings.parseSettings(path, jsonString));
            return defaultSettings;
        }
        return Settings.parseSettings(path, jsonString);
    }

    void readSystemDictionary(String filename) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException("system dictionary is not specified");
        }
        BinaryDictionary dictionary = BinaryDictionary.readSystemDictionary(filename);
        this.dictionaries.add(dictionary);
        this.grammar = dictionary.getGrammar();
        this.lexicon = new LexiconSet(dictionary.getLexicon());
    }

    void readUserDictionary(String filename) throws IOException {
        if (this.lexicon.isFull()) {
            throw new IllegalArgumentException("too many dictionaries");
        }
        BinaryDictionary dictionary = BinaryDictionary.readUserDictionary(filename);
        this.dictionaries.add(dictionary);
        DoubleArrayLexicon userLexicon = dictionary.getLexicon();
        JapaneseTokenizer tokenizer = new JapaneseTokenizer(this.grammar, this.lexicon, this.inputTextPlugins, this.oovProviderPlugins, Collections.emptyList());
        userLexicon.calculateCost(tokenizer);
        this.lexicon.add(userLexicon, (short)this.grammar.getPartOfSpeechSize());
        this.grammar.addPosList(dictionary.getGrammar());
    }

    void readCharacterDefinition(String filename) throws IOException {
        if (this.grammar == null) {
            return;
        }
        CharacterCategory charCategory = new CharacterCategory();
        charCategory.readCharacterDefinition(filename);
        this.grammar.setCharacterCategory(charCategory);
    }

    @Override
    public void close() throws IOException {
        this.grammar = null;
        this.lexicon = null;
        for (BinaryDictionary dictionary : this.dictionaries) {
            dictionary.close();
        }
    }

    @Override
    public Tokenizer create() {
        return new JapaneseTokenizer(this.grammar, this.lexicon, this.inputTextPlugins, this.oovProviderPlugins, this.pathRewritePlugins);
    }

    @Override
    public int getPartOfSpeechSize() {
        return this.grammar.getPartOfSpeechSize();
    }

    @Override
    public List<String> getPartOfSpeechString(short posId) {
        return this.grammar.getPartOfSpeechString(posId);
    }

    /*
     * Exception decompiling
     */
    static String readAll(InputStream input) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

