/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import com.worksap.nlp.sudachi.dictionary.WordInfo;
import java.nio.Buffer;
import java.nio.ByteBuffer;

class WordInfoList {
    private final ByteBuffer bytes;
    private final int offset;
    private final int wordSize;

    WordInfoList(ByteBuffer bytes, int offset, int wordSize) {
        this.bytes = bytes;
        this.offset = offset;
        this.wordSize = wordSize;
    }

    WordInfo getWordInfo(int wordId) {
        ByteBuffer buf = this.bytes.asReadOnlyBuffer();
        buf.order(this.bytes.order());
        ((Buffer)buf).position(this.wordIdToOffset(wordId));
        String surface = this.bufferToString(buf);
        short headwordLength = (short)this.bufferToStringLength(buf);
        short posId = buf.getShort();
        String normalizedForm = this.bufferToString(buf);
        if (normalizedForm.isEmpty()) {
            normalizedForm = surface;
        }
        int dictionaryFormWordId = buf.getInt();
        String readingForm = this.bufferToString(buf);
        if (readingForm.isEmpty()) {
            readingForm = surface;
        }
        int[] aUnitSplit = this.bufferToIntArray(buf);
        int[] bUnitSplit = this.bufferToIntArray(buf);
        int[] wordStructure = this.bufferToIntArray(buf);
        String dictionaryForm = surface;
        if (dictionaryFormWordId >= 0 && dictionaryFormWordId != wordId) {
            WordInfo wi = this.getWordInfo(dictionaryFormWordId);
            dictionaryForm = wi.getSurface();
        }
        return new WordInfo(surface, headwordLength, posId, normalizedForm, dictionaryFormWordId, dictionaryForm, readingForm, aUnitSplit, bUnitSplit, wordStructure);
    }

    int size() {
        return this.wordSize;
    }

    private int wordIdToOffset(int wordId) {
        return this.bytes.getInt(this.offset + 4 * wordId);
    }

    private int bufferToStringLength(ByteBuffer buffer) {
        byte length = buffer.get();
        if (length < 0) {
            int high = Byte.toUnsignedInt(length);
            int low = Byte.toUnsignedInt(buffer.get());
            return (high & 0x7F) << 8 | low;
        }
        return length;
    }

    private String bufferToString(ByteBuffer buffer) {
        int length = this.bufferToStringLength(buffer);
        char[] str = new char[length];
        for (int i = 0; i < length; ++i) {
            str[i] = buffer.getChar();
        }
        return new String(str);
    }

    private int[] bufferToIntArray(ByteBuffer buffer) {
        int length = Byte.toUnsignedInt(buffer.get());
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = buffer.getInt();
        }
        return array;
    }
}

