/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi.dictionary;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public class DictionaryHeader {
    private final long version;
    private final long createTime;
    private final String description;
    private static final int DESCRIPTION_SIZE = 256;
    private static final int STORAGE_SIZE = 272;

    DictionaryHeader(long version, long createTime, String description) {
        this.version = version;
        this.createTime = createTime;
        this.description = description;
    }

    public DictionaryHeader(ByteBuffer input, int offset) {
        int length;
        this.version = input.getLong(offset);
        this.createTime = input.getLong(offset += 8);
        offset += 8;
        byte[] byteDescription = new byte[256];
        for (length = 0; length < 256; ++length) {
            byteDescription[length] = input.get(offset++);
            if (byteDescription[length] == 0) break;
        }
        this.description = new String(byteDescription, 0, length, StandardCharsets.UTF_8);
    }

    public int storageSize() {
        return 272;
    }

    byte[] toByte() {
        byte[] output = new byte[272];
        ByteBuffer buffer = ByteBuffer.wrap(output);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(this.version);
        buffer.putLong(this.createTime);
        byte[] byteDescription = this.description.getBytes(StandardCharsets.UTF_8);
        if (byteDescription.length > 256) {
            throw new IllegalArgumentException("description is too long");
        }
        buffer.put(byteDescription);
        return output;
    }

    public long getVersion() {
        return this.version;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public String getDescription() {
        return this.description;
    }
}

