/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.InputText;
import com.worksap.nlp.sudachi.dictionary.CategoryType;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

class UTF8InputText
implements InputText {
    private final String originalText;
    private final String modifiedText;
    private final byte[] bytes;
    private final int[] offsets;
    private final int[] byteIndexes;
    private final List<EnumSet<CategoryType>> charCategories;
    private final List<Integer> charCategoryContinuities;
    private final List<Boolean> canBowList;

    UTF8InputText(Grammar grammar, String originalText, String modifiedText, byte[] bytes, int[] offsets, int[] byteIndexes, List<EnumSet<CategoryType>> charCategories, List<Integer> charCategoryContinuities, List<Boolean> canBowList) {
        this.originalText = originalText;
        this.modifiedText = modifiedText;
        this.bytes = bytes;
        this.offsets = offsets;
        this.byteIndexes = byteIndexes;
        this.charCategories = charCategories;
        this.charCategoryContinuities = charCategoryContinuities;
        this.canBowList = canBowList;
    }

    @Override
    public String getOriginalText() {
        return this.originalText;
    }

    @Override
    public String getText() {
        return this.modifiedText;
    }

    byte[] getByteText() {
        return this.bytes;
    }

    @Override
    public String getSubstring(int begin, int end) {
        if (begin < 0) {
            throw new StringIndexOutOfBoundsException(begin);
        }
        if (end > this.bytes.length) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (begin > end) {
            throw new StringIndexOutOfBoundsException(end - begin);
        }
        return this.modifiedText.substring(this.byteIndexes[begin], this.byteIndexes[end]);
    }

    int getOffsetTextLength(int index) {
        return this.byteIndexes[index];
    }

    @Override
    public int getOriginalIndex(int index) {
        return this.offsets[index];
    }

    @Override
    public Set<CategoryType> getCharCategoryTypes(int index) {
        return this.charCategories.get(this.byteIndexes[index]);
    }

    @Override
    public Set<CategoryType> getCharCategoryTypes(int begin, int end) {
        if (begin + this.getCharCategoryContinuousLength(begin) < end) {
            return Collections.emptySet();
        }
        int b = this.byteIndexes[begin];
        int e = this.byteIndexes[end];
        Object continuousCategory = this.charCategories.get(b).clone();
        for (int i = b + 1; i < e; ++i) {
            continuousCategory.retainAll((Collection)this.charCategories.get(i));
        }
        return continuousCategory;
    }

    @Override
    public int getCharCategoryContinuousLength(int index) {
        return this.charCategoryContinuities.get(index);
    }

    @Override
    public int getCodePointsOffsetLength(int index, int codePointOffset) {
        int length = 0;
        int target = this.byteIndexes[index] + codePointOffset;
        for (int i = index; i < this.bytes.length; ++i) {
            if (this.byteIndexes[i] >= target) {
                return length;
            }
            ++length;
        }
        return length;
    }

    @Override
    public int codePointCount(int begin, int end) {
        return this.byteIndexes[end] - this.byteIndexes[begin];
    }

    @Override
    public boolean canBow(int index) {
        return this.isCharAlignment(index) && this.canBowList.get(this.byteIndexes[index]) != false;
    }

    @Override
    public int getWordCandidateLength(int index) {
        for (int i = index + 1; i < this.bytes.length; ++i) {
            if (!this.canBow(i)) continue;
            return i - index;
        }
        return this.bytes.length - index;
    }

    private boolean isCharAlignment(int index) {
        return (this.bytes[index] & 0xC0) != 128;
    }
}

