/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.InputText;
import com.worksap.nlp.sudachi.LatticeNode;
import com.worksap.nlp.sudachi.OovProviderPlugin;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import com.worksap.nlp.sudachi.dictionary.WordInfo;
import java.util.Collections;
import java.util.List;

class SimpleOovProviderPlugin
extends OovProviderPlugin {
    short oovPOSId;
    short leftId;
    short rightId;
    short cost;

    SimpleOovProviderPlugin() {
    }

    @Override
    public void setUp(Grammar grammar) {
        List<String> oovPOSStrings = this.settings.getStringList("oovPOS");
        this.leftId = (short)this.settings.getInt("leftId");
        this.rightId = (short)this.settings.getInt("rightId");
        this.cost = (short)this.settings.getInt("cost");
        if (oovPOSStrings.isEmpty()) {
            throw new IllegalArgumentException("oovPOS is not specified");
        }
        this.oovPOSId = grammar.getPartOfSpeechId(oovPOSStrings);
        if (this.oovPOSId < 0) {
            throw new IllegalArgumentException("oovPOS is invalid:" + String.join((CharSequence)",", oovPOSStrings));
        }
    }

    @Override
    public List<LatticeNode> provideOOV(InputText inputText, int offset, boolean hasOtherWords) {
        if (!hasOtherWords) {
            LatticeNode node = this.createNode();
            node.setParameter(this.leftId, this.rightId, this.cost);
            int length = inputText.getWordCandidateLength(offset);
            String s = inputText.getSubstring(offset, offset + length);
            WordInfo info = new WordInfo(s, (short)length, this.oovPOSId, s, s, "");
            node.setWordInfo(info);
            return Collections.singletonList(node);
        }
        return Collections.emptyList();
    }
}

