/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.Plugin;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;

public class Settings {
    JsonObject root;
    String basePath;

    Settings(JsonObject root, String basePath) {
        this.root = root;
        this.basePath = basePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Settings parseSettings(String path, String json) {
        try (JsonReader reader = Json.createReader((Reader)new StringReader(json));){
            JsonStructure rootStr = reader.read();
            if (rootStr instanceof JsonObject) {
                JsonObject root = (JsonObject)rootStr;
                String basePath = root.getString("path", path);
                Settings settings = new Settings(root, basePath);
                return settings;
            }
            throw new IllegalArgumentException("root must be an object");
        }
        catch (JsonParsingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getString(String setting) {
        try {
            return this.root.getString(setting);
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(setting + " is not a string", e);
        }
    }

    public String getString(String setting, String defaultValue) {
        return this.root.getString(setting, defaultValue);
    }

    public List<String> getStringList(String setting) {
        try {
            JsonArray array = this.root.getJsonArray(setting);
            if (array == null) {
                return Collections.emptyList();
            }
            ArrayList<String> result = new ArrayList<String>(array.size());
            for (int i = 0; i < array.size(); ++i) {
                result.add(array.getString(i));
            }
            return result;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(setting + " is not an array of strings", e);
        }
    }

    public int getInt(String setting) {
        try {
            return this.root.getInt(setting);
        }
        catch (NullPointerException e) {
            return 0;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(setting + " is not a number", e);
        }
    }

    public int getInt(String setting, int defaultValue) {
        try {
            return this.root.getInt(setting, defaultValue);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(setting + " is not a number", e);
        }
    }

    public List<Integer> getIntList(String setting) {
        try {
            return this.getList(setting, JsonNumber.class).stream().map(JsonNumber::intValue).collect(Collectors.toList());
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(setting + " is not an array of numbers", e);
        }
    }

    public List<List<Integer>> getIntListList(String setting) {
        try {
            return this.getList(setting, JsonArray.class).stream().map(a -> a.getValuesAs(JsonNumber.class).stream().map(JsonNumber::intValue).collect(Collectors.toList())).collect(Collectors.toList());
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(setting + " is not an array of arrays of numbers", e);
        }
    }

    public String getPath(String setting) {
        String path = this.getString(setting);
        return path == null || this.isAbsolutePath(path) || this.basePath == null ? path : Paths.get(this.basePath, path).toString();
    }

    public List<String> getPathList(String setting) {
        List<String> list = this.getStringList(setting);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list.stream().map(p -> this.isAbsolutePath((String)p) || this.basePath == null ? p : Paths.get(this.basePath, p).toString()).collect(Collectors.toList());
    }

    public boolean getBoolean(String setting, boolean defaultValue) {
        return this.root.getBoolean(setting, defaultValue);
    }

    <E extends JsonValue> List<E> getList(String setting, Class<E> clazz) {
        JsonArray array = this.root.getJsonArray(setting);
        if (array == null) {
            return Collections.emptyList();
        }
        return array.getValuesAs(clazz);
    }

    <E extends Plugin> List<E> getPluginList(String setting) {
        List<JsonObject> list;
        try {
            list = this.getList(setting, JsonObject.class);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(setting + " is not a array of object", e);
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Plugin> result = new ArrayList<Plugin>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object o;
            String classname;
            try {
                classname = list.get(i).getString("class");
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException(setting + " has a member without a \"class\"", e);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(setting + " has a member with invalid \"class\"", e);
            }
            try {
                o = this.getClass().getClassLoader().loadClass(classname).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalArgumentException(classname + " in " + setting + " cannot be initialized", e);
            }
            if (!(o instanceof Plugin)) {
                throw new IllegalArgumentException(classname + " in " + setting + " is not a plugin");
            }
            Plugin plugin = (Plugin)o;
            plugin.setSettings(new Settings(list.get(i), this.basePath));
            result.add(plugin);
        }
        return result;
    }

    void merge(Settings settings) {
        if (settings.basePath != null) {
            this.basePath = settings.basePath;
        }
        JsonObjectBuilder newRoot = Json.createObjectBuilder();
        for (Map.Entry thisEntry : this.root.entrySet()) {
            String thisKey = (String)thisEntry.getKey();
            JsonValue thisValue = (JsonValue)thisEntry.getValue();
            if (settings.root.containsKey((Object)thisKey)) {
                JsonValue value = (JsonValue)settings.root.get((Object)thisKey);
                if (thisValue instanceof JsonString || thisValue instanceof JsonNumber || thisValue instanceof JsonObject) {
                    newRoot.add(thisKey, value);
                    continue;
                }
                if (!(thisValue instanceof JsonArray)) continue;
                newRoot.add(thisKey, (JsonValue)this.mergeArray(thisValue, value));
                continue;
            }
            newRoot.add(thisKey, thisValue);
        }
        for (Map.Entry entry : settings.root.entrySet()) {
            if (this.root.containsKey(entry.getKey())) continue;
            newRoot.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        this.root = newRoot.build();
    }

    private JsonArray mergeArray(JsonValue thisValue, JsonValue value) {
        if (value instanceof JsonArray && ((JsonArray)value).isEmpty()) {
            return (JsonArray)value;
        }
        JsonArray thisList = (JsonArray)thisValue;
        JsonArrayBuilder newList = Json.createArrayBuilder();
        HashMap<Integer, JsonValue> replaceItems = new HashMap<Integer, JsonValue>();
        for (JsonValue item : (JsonArray)value) {
            boolean isReplaced = false;
            if (item instanceof JsonObject && ((JsonObject)item).containsKey((Object)"class")) {
                JsonValue className = (JsonValue)((JsonObject)item).get((Object)"class");
                for (int i = 0; i < thisList.size(); ++i) {
                    JsonValue thisItem = (JsonValue)thisList.get(i);
                    if (!(thisItem instanceof JsonObject) || !((JsonValue)((JsonObject)thisItem).get((Object)"class")).equals(className)) continue;
                    replaceItems.put(i, item);
                    isReplaced = true;
                }
            }
            if (isReplaced) continue;
            newList.add(item);
        }
        for (int i = 0; i < thisList.size(); ++i) {
            JsonValue item;
            item = (JsonValue)replaceItems.get(i);
            newList.add(item == null ? (JsonValue)thisList.get(i) : item);
        }
        return newList.build();
    }

    private boolean isAbsolutePath(String path) {
        File file = new File(path);
        return file.isAbsolute();
    }
}

