/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.InputTextBuilder;
import com.worksap.nlp.sudachi.InputTextPlugin;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class ProlongedSoundMarkInputTextPlugin
extends InputTextPlugin {
    private Set<Integer> prolongedSoundMarkSet = new HashSet<Integer>();
    private String replacementSymbol;

    ProlongedSoundMarkInputTextPlugin() {
    }

    @Override
    public void setUp() throws IOException {
        List<String> prolongedSoundMarkStrings = this.settings.getStringList("prolongedSoundMarks");
        for (String s : prolongedSoundMarkStrings) {
            this.prolongedSoundMarkSet.add(s.codePointAt(0));
        }
        this.replacementSymbol = this.settings.getString("replacementSymbol");
    }

    @Override
    public void rewrite(InputTextBuilder builder) {
        String text = builder.getText();
        int n = text.length();
        int offset = 0;
        int markStartIndex = n;
        boolean isProlongedSoundMark = false;
        for (int i = 0; i < n; ++i) {
            int cp = text.codePointAt(i);
            if (!isProlongedSoundMark && this.prolongedSoundMarkSet.contains(cp)) {
                isProlongedSoundMark = true;
                markStartIndex = i;
                continue;
            }
            if (!isProlongedSoundMark || this.prolongedSoundMarkSet.contains(cp)) continue;
            if (i - markStartIndex > 1) {
                builder.replace(markStartIndex - offset, i - offset, this.replacementSymbol);
                offset += i - markStartIndex - 1;
            }
            isProlongedSoundMark = false;
        }
        if (isProlongedSoundMark && n - markStartIndex > 1) {
            builder.replace(markStartIndex - offset, n - offset, this.replacementSymbol);
        }
    }
}

