/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import java.util.HashMap;
import java.util.Map;

class NumericParser {
    private static final Map<Character, Integer> CHAR_TO_NUM;
    int digitLength;
    boolean isFirstDigit;
    boolean hasComma;
    boolean hasHangingPoint;
    Error errorState;
    StringNumber total = new StringNumber();
    StringNumber subtotal = new StringNumber();
    StringNumber tmp = new StringNumber();

    NumericParser() {
        this.clear();
    }

    void clear() {
        this.digitLength = 0;
        this.isFirstDigit = true;
        this.hasComma = false;
        this.hasHangingPoint = false;
        this.errorState = Error.NONE;
        this.total.clear();
        this.subtotal.clear();
        this.tmp.clear();
    }

    boolean append(char c) {
        if (c == '.') {
            this.hasHangingPoint = true;
            if (this.isFirstDigit) {
                this.errorState = Error.POINT;
                return false;
            }
            if (this.hasComma && !this.checkComma()) {
                this.errorState = Error.COMMA;
                return false;
            }
            if (!this.tmp.setPoint()) {
                this.errorState = Error.POINT;
                return false;
            }
            this.hasComma = false;
            return true;
        }
        if (c == ',') {
            if (!this.checkComma()) {
                this.errorState = Error.COMMA;
                return false;
            }
            this.hasComma = true;
            this.digitLength = 0;
            return true;
        }
        Integer n = CHAR_TO_NUM.get(Character.valueOf(c));
        if (n == null) {
            return false;
        }
        if (this.isSmallUnit(n)) {
            this.tmp.shiftScale(-n.intValue());
            if (!this.subtotal.add(this.tmp)) {
                return false;
            }
            this.tmp.clear();
            this.isFirstDigit = true;
            this.digitLength = 0;
            this.hasComma = false;
        } else if (this.isLargeUnit(n)) {
            if (!this.subtotal.add(this.tmp) || this.subtotal.isZero()) {
                return false;
            }
            this.subtotal.shiftScale(-n.intValue());
            if (!this.total.add(this.subtotal)) {
                return false;
            }
            this.subtotal.clear();
            this.tmp.clear();
            this.isFirstDigit = true;
            this.digitLength = 0;
            this.hasComma = false;
        } else {
            this.tmp.append(n);
            this.isFirstDigit = false;
            ++this.digitLength;
            this.hasHangingPoint = false;
        }
        return true;
    }

    boolean done() {
        boolean ret;
        boolean bl = ret = this.subtotal.add(this.tmp) && this.total.add(this.subtotal);
        if (this.hasHangingPoint) {
            this.errorState = Error.POINT;
            return false;
        }
        if (this.hasComma && this.digitLength != 3) {
            this.errorState = Error.COMMA;
            return false;
        }
        return ret;
    }

    String getNormalized() {
        return this.total.toString();
    }

    private boolean checkComma() {
        if (this.isFirstDigit) {
            return false;
        }
        if (!this.hasComma) {
            return this.digitLength <= 3 && !this.tmp.isZero() && !this.tmp.isAllZero;
        }
        return this.digitLength == 3;
    }

    private boolean isSmallUnit(int n) {
        return n < 0 && n >= -3;
    }

    private boolean isLargeUnit(int n) {
        return n <= -4;
    }

    static {
        HashMap<Character, Integer> map = new HashMap<Character, Integer>();
        for (int i = 0; i < 10; ++i) {
            map.put(Character.valueOf((char)(48 + i)), i);
        }
        map.put(Character.valueOf('\u3007'), 0);
        map.put(Character.valueOf('\u4e00'), 1);
        map.put(Character.valueOf('\u4e8c'), 2);
        map.put(Character.valueOf('\u4e09'), 3);
        map.put(Character.valueOf('\u56db'), 4);
        map.put(Character.valueOf('\u4e94'), 5);
        map.put(Character.valueOf('\u516d'), 6);
        map.put(Character.valueOf('\u4e03'), 7);
        map.put(Character.valueOf('\u516b'), 8);
        map.put(Character.valueOf('\u4e5d'), 9);
        map.put(Character.valueOf('\u5341'), -1);
        map.put(Character.valueOf('\u767e'), -2);
        map.put(Character.valueOf('\u5343'), -3);
        map.put(Character.valueOf('\u4e07'), -4);
        map.put(Character.valueOf('\u5104'), -8);
        map.put(Character.valueOf('\u5146'), -12);
        CHAR_TO_NUM = map;
    }

    static enum Error {
        NONE,
        POINT,
        COMMA,
        OTHER;

    }

    static class StringNumber {
        StringBuilder significand = new StringBuilder();
        int scale = 0;
        int point = -1;
        boolean isAllZero = true;

        StringNumber() {
        }

        void clear() {
            this.significand.setLength(0);
            this.scale = 0;
            this.point = -1;
            this.isAllZero = true;
        }

        void append(int i) {
            if (i != 0) {
                this.isAllZero = false;
            }
            this.significand.append(StringNumber.intToChar(i));
        }

        void shiftScale(int i) {
            if (this.isZero()) {
                this.significand.append('1');
            }
            this.scale += i;
        }

        boolean add(StringNumber number) {
            if (number.isZero()) {
                return true;
            }
            if (this.isZero()) {
                this.significand.append((CharSequence)number.significand);
                this.scale = number.scale;
                this.point = number.point;
                return true;
            }
            this.normalizeScale();
            int l = number.intLength();
            if (this.scale >= l) {
                this.fillZero(this.scale - l);
                if (number.point >= 0) {
                    this.point = this.significand.length() + number.point;
                }
                this.significand.append(number.significand.toString());
                this.scale = number.scale;
                return true;
            }
            return false;
        }

        boolean setPoint() {
            if (this.scale == 0 && this.point < 0) {
                this.point = this.significand.length();
                return true;
            }
            return false;
        }

        int intLength() {
            this.normalizeScale();
            if (this.point >= 0) {
                return this.point;
            }
            return this.significand.length() + this.scale;
        }

        boolean isZero() {
            return this.significand.length() == 0;
        }

        public String toString() {
            if (this.isZero()) {
                return "0";
            }
            this.normalizeScale();
            if (this.scale > 0) {
                this.fillZero(this.scale);
            } else if (this.point >= 0) {
                int i;
                this.significand.insert(this.point, '.');
                if (this.point == 0) {
                    this.significand.insert(0, '0');
                }
                for (i = this.significand.length() - 1; i >= 0 && this.significand.charAt(i) == '0'; --i) {
                }
                this.significand.delete(i + 1, this.significand.length());
                if (this.significand.charAt(this.significand.length() - 1) == '.') {
                    this.significand.deleteCharAt(this.significand.length() - 1);
                }
            }
            return this.significand.toString();
        }

        private void normalizeScale() {
            if (this.point >= 0) {
                int nScale = this.significand.length() - this.point;
                if (nScale > this.scale) {
                    this.point += this.scale;
                    this.scale = 0;
                } else {
                    this.scale -= nScale;
                    this.point = -1;
                }
            }
        }

        private void fillZero(int length) {
            for (int i = 0; i < length; ++i) {
                this.significand.append('0');
            }
        }

        private static char intToChar(int i) {
            return (char)(48 + i);
        }
    }
}

