/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.sudachi;

import com.worksap.nlp.sudachi.InputText;
import com.worksap.nlp.sudachi.LatticeNode;
import com.worksap.nlp.sudachi.LatticeNodeImpl;
import com.worksap.nlp.sudachi.Morpheme;
import com.worksap.nlp.sudachi.MorphemeImpl;
import com.worksap.nlp.sudachi.Tokenizer;
import com.worksap.nlp.sudachi.dictionary.Grammar;
import com.worksap.nlp.sudachi.dictionary.Lexicon;
import com.worksap.nlp.sudachi.dictionary.WordInfo;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MorphemeList
extends AbstractList<Morpheme> {
    final InputText inputText;
    final Grammar grammar;
    final Lexicon lexicon;
    final List<LatticeNode> path;

    MorphemeList(InputText input, Grammar grammar, Lexicon lexicon, List<LatticeNode> path) {
        this.inputText = input;
        this.grammar = grammar;
        this.lexicon = lexicon;
        this.path = path;
    }

    @Override
    public Morpheme get(int index) {
        return new MorphemeImpl(this, index);
    }

    @Override
    public int size() {
        return this.path.size();
    }

    int getBegin(int index) {
        return this.inputText.getOriginalIndex(this.path.get(index).getBegin());
    }

    int getEnd(int index) {
        return this.inputText.getOriginalIndex(this.path.get(index).getEnd());
    }

    String getSurface(int index) {
        int begin = this.getBegin(index);
        int end = this.getEnd(index);
        return this.inputText.getOriginalText().substring(begin, end);
    }

    WordInfo getWordInfo(int index) {
        return this.path.get(index).getWordInfo();
    }

    List<Morpheme> split(Tokenizer.SplitMode mode, int index, WordInfo wi) {
        int[] wordIds;
        switch (mode) {
            case A: {
                wordIds = wi.getAunitSplit();
                break;
            }
            case B: {
                wordIds = wi.getBunitSplit();
                break;
            }
            default: {
                return Collections.singletonList(this.get(index));
            }
        }
        if (wordIds.length == 0 || wordIds.length == 1) {
            return Collections.singletonList(this.get(index));
        }
        int offset = this.path.get(index).getBegin();
        ArrayList<LatticeNode> nodes = new ArrayList<LatticeNode>(wordIds.length);
        for (int wid : wordIds) {
            LatticeNodeImpl n = new LatticeNodeImpl(this.lexicon, 0, 0, 0, wid);
            n.begin = offset;
            n.end = offset += n.getWordInfo().getLength();
            nodes.add(n);
        }
        return new MorphemeList(this.inputText, this.grammar, this.lexicon, nodes);
    }

    boolean isOOV(int index) {
        return this.path.get(index).isOOV();
    }

    int getWordId(int index) {
        return this.path.get(index).getWordId();
    }

    int getDictionaryId(int index) {
        return this.path.get(index).getDictionaryId();
    }

    public int getInternalCost() {
        return this.path.get(this.path.size() - 1).getPathCost() - this.path.get(0).getPathCost();
    }
}

