/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.dartsclone.details;

import com.worksap.nlp.dartsclone.details.BitVector;
import java.util.ArrayList;
import java.util.List;

class DAWGBuilder {
    private static final int INITIAL_TABLE_SIZE = 1024;
    private ArrayList<Node> nodes = new ArrayList();
    private ArrayList<Unit> units = new ArrayList();
    private ArrayList<Byte> labels = new ArrayList();
    private BitVector isIntersections = new BitVector();
    private ArrayList<Integer> table = new ArrayList();
    private ArrayList<Integer> nodeStack = new ArrayList();
    private ArrayList<Integer> recycleBin = new ArrayList();
    private int numStates;

    DAWGBuilder() {
    }

    int root() {
        return 0;
    }

    int child(int id) {
        return this.units.get(id).child();
    }

    int sibling(int id) {
        return this.units.get(id).hasSibling() ? id + 1 : 0;
    }

    int value(int id) {
        return this.units.get(id).value();
    }

    boolean isLeaf(int id) {
        return this.label(id) == 0;
    }

    byte label(int id) {
        return this.labels.get(id);
    }

    boolean isIntersection(int id) {
        return this.isIntersections.get(id);
    }

    int intersectionId(int id) {
        return this.isIntersections.rank(id) - 1;
    }

    int numIntersections() {
        return this.isIntersections.numOnes();
    }

    int size() {
        return this.units.size();
    }

    void init() {
        this.table.ensureCapacity(1024);
        for (int i = 0; i < 1024; ++i) {
            this.table.add(0);
        }
        this.appendNode();
        this.appendUnit();
        this.numStates = 1;
        this.nodes.get((int)0).label = (byte)-1;
        this.nodeStack.add(0);
    }

    void finish() {
        this.flush(0);
        this.units.get((int)0).unit = this.nodes.get(0).unit();
        this.labels.set(0, this.nodes.get((int)0).label);
        this.nodes = null;
        this.table = null;
        this.nodeStack = null;
        this.recycleBin = null;
        this.isIntersections.build();
    }

    void insert(byte[] key, int value) {
        int childId;
        int keyPos;
        if (value < 0) {
            throw new IllegalArgumentException("negative value");
        }
        if (key.length == 0) {
            throw new IllegalArgumentException("zero-length key");
        }
        int id = 0;
        for (keyPos = 0; keyPos <= key.length && (childId = this.nodes.get((int)id).child) != 0; ++keyPos) {
            byte keyLabel;
            byte by = keyLabel = keyPos < key.length ? key[keyPos] : (byte)0;
            if (keyPos < key.length && keyLabel == 0) {
                throw new IllegalArgumentException("invalid null character");
            }
            byte unitLabel = this.nodes.get((int)childId).label;
            if (Byte.toUnsignedInt(keyLabel) < Byte.toUnsignedInt(unitLabel)) {
                throw new IllegalArgumentException("wrong key order");
            }
            if (Byte.toUnsignedInt(keyLabel) > Byte.toUnsignedInt(unitLabel)) {
                this.nodes.get((int)childId).hasSibling = true;
                this.flush(childId);
                break;
            }
            id = childId;
        }
        if (keyPos > key.length) {
            return;
        }
        while (keyPos <= key.length) {
            byte keyLabel = keyPos < key.length ? key[keyPos] : (byte)0;
            int childId2 = this.appendNode();
            if (this.nodes.get((int)id).child == 0) {
                this.nodes.get((int)childId2).isState = true;
            }
            this.nodes.get((int)childId2).sibling = this.nodes.get((int)id).child;
            this.nodes.get((int)childId2).label = keyLabel;
            this.nodes.get((int)id).child = childId2;
            this.nodeStack.add(childId2);
            id = childId2;
            ++keyPos;
        }
        this.nodes.get(id).setValue(value);
    }

    void clear() {
        this.nodes = null;
        this.units = null;
        this.labels = null;
        this.isIntersections = null;
        this.table = null;
        this.nodeStack = null;
        this.recycleBin = null;
    }

    private void flush(int id) {
        while (DAWGBuilder.stackTop(this.nodeStack) != id) {
            int nodeId = DAWGBuilder.stackTop(this.nodeStack);
            DAWGBuilder.stackPop(this.nodeStack);
            if (this.numStates >= this.table.size() - (this.table.size() >>> 2)) {
                this.expandTable();
            }
            int numSiblings = 0;
            int i = nodeId;
            while (i != 0) {
                ++numSiblings;
                i = this.nodes.get((int)i).sibling;
            }
            int[] findResult = this.findNode(nodeId);
            int matchId = findResult[0];
            int hashId = findResult[1];
            if (matchId != 0) {
                this.isIntersections.set(matchId, true);
            } else {
                int i2;
                int unitId = 0;
                for (i2 = 0; i2 < numSiblings; ++i2) {
                    unitId = this.appendUnit();
                }
                i2 = nodeId;
                while (i2 != 0) {
                    this.units.get((int)unitId).unit = this.nodes.get(i2).unit();
                    this.labels.set(unitId, this.nodes.get((int)i2).label);
                    --unitId;
                    i2 = this.nodes.get((int)i2).sibling;
                }
                matchId = unitId + 1;
                this.table.set(hashId, matchId);
                ++this.numStates;
            }
            int i3 = nodeId;
            while (i3 != 0) {
                int next = this.nodes.get((int)i3).sibling;
                this.freeNode(i3);
                i3 = next;
            }
            this.nodes.get((int)DAWGBuilder.stackTop(this.nodeStack).intValue()).child = matchId;
        }
        DAWGBuilder.stackPop(this.nodeStack);
    }

    void expandTable() {
        int tableSize = this.table.size() << 1;
        this.table.clear();
        this.table.ensureCapacity(tableSize);
        for (int i = 0; i < tableSize; ++i) {
            this.table.add(0);
        }
        for (int id = 1; id < this.units.size(); ++id) {
            if (this.labels.get(id) != 0 && !this.units.get(id).isState()) continue;
            int[] findResult = this.findUnit(id);
            int hashId = findResult[1];
            this.table.set(hashId, id);
        }
    }

    private int[] findUnit(int id) {
        int unitId;
        int[] result = new int[2];
        int hashId = this.hashUnit(id) % this.table.size();
        while ((unitId = this.table.get(hashId).intValue()) != 0) {
            hashId = (hashId + 1) % this.table.size();
        }
        result[1] = hashId;
        return result;
    }

    private int[] findNode(int nodeId) {
        int unitId;
        int[] result = new int[2];
        int hashId = this.hashNode(nodeId) % this.table.size();
        while ((unitId = this.table.get(hashId).intValue()) != 0) {
            if (this.areEqual(nodeId, unitId)) {
                result[0] = unitId;
                result[1] = hashId;
                return result;
            }
            hashId = (hashId + 1) % this.table.size();
        }
        result[1] = hashId;
        return result;
    }

    private boolean areEqual(int nodeId, int unitId) {
        int i = this.nodes.get((int)nodeId).sibling;
        while (i != 0) {
            if (!this.units.get(unitId).hasSibling()) {
                return false;
            }
            ++unitId;
            i = this.nodes.get((int)i).sibling;
        }
        if (this.units.get(unitId).hasSibling()) {
            return false;
        }
        i = nodeId;
        while (i != 0) {
            if (this.nodes.get(i).unit() != this.units.get((int)unitId).unit || this.nodes.get((int)i).label != this.labels.get(unitId)) {
                return false;
            }
            i = this.nodes.get((int)i).sibling;
            --unitId;
        }
        return true;
    }

    private int hashUnit(int id) {
        int hashValue = 0;
        while (id != 0) {
            int unit = this.units.get((int)id).unit;
            byte label = this.labels.get(id);
            hashValue ^= DAWGBuilder.hash(Byte.toUnsignedInt(label) << 24 ^ unit);
            if (!this.units.get(id).hasSibling()) break;
            ++id;
        }
        return hashValue;
    }

    private int hashNode(int id) {
        int hashValue = 0;
        while (id != 0) {
            int unit = this.nodes.get(id).unit();
            byte label = this.nodes.get((int)id).label;
            hashValue ^= DAWGBuilder.hash(Byte.toUnsignedInt(label) << 24 ^ unit);
            id = this.nodes.get((int)id).sibling;
        }
        return hashValue;
    }

    private int appendUnit() {
        this.isIntersections.append();
        this.units.add(new Unit());
        this.labels.add((byte)0);
        return this.isIntersections.size() - 1;
    }

    private int appendNode() {
        int id;
        if (this.recycleBin.isEmpty()) {
            id = this.nodes.size();
            this.nodes.add(new Node());
        } else {
            id = DAWGBuilder.stackTop(this.recycleBin);
            this.nodes.get(id).reset();
            DAWGBuilder.stackPop(this.recycleBin);
        }
        return id;
    }

    private void freeNode(int id) {
        this.recycleBin.add(id);
    }

    private static int hash(int key) {
        key = ~key + (key << 15);
        key ^= key >> 12;
        key += key << 2;
        key ^= key >> 4;
        key *= 2057;
        key ^= key >> 16;
        return key;
    }

    private static <E> E stackTop(List<E> stack) {
        return stack.get(stack.size() - 1);
    }

    private static <E> void stackPop(List<E> stack) {
        stack.remove(stack.size() - 1);
    }

    static class Unit {
        int unit;

        Unit() {
        }

        int child() {
            return this.unit >>> 2;
        }

        boolean hasSibling() {
            return (this.unit & 1) == 1;
        }

        int value() {
            return this.unit >>> 1;
        }

        boolean isState() {
            return (this.unit & 2) == 2;
        }
    }

    static class Node {
        int child;
        int sibling;
        byte label;
        boolean isState;
        boolean hasSibling;

        Node() {
        }

        void reset() {
            this.child = 0;
            this.sibling = 0;
            this.label = 0;
            this.isState = false;
            this.hasSibling = false;
        }

        int getValue() {
            return this.child;
        }

        void setValue(int value) {
            this.child = value;
        }

        int unit() {
            if (this.label == 0) {
                return this.child << 1 | (this.hasSibling ? 1 : 0);
            }
            return this.child << 2 | (this.isState ? 2 : 0) | (this.hasSibling ? 1 : 0);
        }
    }
}

