/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.dartsclone.details;

import com.worksap.nlp.dartsclone.details.DAWGBuilder;
import com.worksap.nlp.dartsclone.details.DoubleArrayBuilderUnit;
import com.worksap.nlp.dartsclone.details.KeySet;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.function.BiConsumer;

public class DoubleArrayBuilder {
    private static final int BLOCK_SIZE = 256;
    private static final int NUM_EXTRA_BLOCKS = 16;
    private static final int NUM_EXTRAS = 4096;
    private static final int UPPER_MASK = 534773760;
    private static final int LOWER_MASK = 255;
    private BiConsumer<Integer, Integer> progressFunction;
    private ArrayList<DoubleArrayBuilderUnit> units = new ArrayList();
    private DoubleArrayBuilderExtraUnit[] extras;
    private ArrayList<Byte> labels = new ArrayList();
    private int[] table;
    private int extrasHead;

    public DoubleArrayBuilder(BiConsumer<Integer, Integer> progressFunction) {
        this.progressFunction = progressFunction;
    }

    public void build(KeySet keySet) {
        if (keySet.hasValues()) {
            DAWGBuilder dawgBuilder = new DAWGBuilder();
            this.buildDAWG(keySet, dawgBuilder);
            this.buildFromDAWG(dawgBuilder);
            dawgBuilder.clear();
        } else {
            this.buildFromKeySet(keySet);
        }
    }

    public ByteBuffer copy() {
        ByteBuffer buffer = ByteBuffer.allocate(this.units.size() * 4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (DoubleArrayBuilderUnit u : this.units) {
            buffer.putInt(u.unit);
        }
        buffer.rewind();
        return buffer;
    }

    public void clear() {
        this.units = null;
        this.extras = null;
        this.labels = null;
        this.table = null;
    }

    int numBlocks() {
        return this.units.size() / 256;
    }

    DoubleArrayBuilderExtraUnit extras(int id) {
        return this.extras[id % 4096];
    }

    void buildDAWG(KeySet keySet, DAWGBuilder dawgBuilder) {
        dawgBuilder.init();
        for (int i = 0; i < keySet.size(); ++i) {
            dawgBuilder.insert(keySet.getKey(i), keySet.getValue(i));
            if (this.progressFunction == null) continue;
            this.progressFunction.accept(i + 1, keySet.size() + 1);
        }
        dawgBuilder.finish();
    }

    void buildFromDAWG(DAWGBuilder dawg) {
        int numUnits;
        for (numUnits = 1; numUnits < dawg.size(); numUnits <<= 1) {
        }
        this.units.ensureCapacity(numUnits);
        this.table = new int[dawg.numIntersections()];
        this.extras = new DoubleArrayBuilderExtraUnit[4096];
        for (int i = 0; i < this.extras.length; ++i) {
            this.extras[i] = new DoubleArrayBuilderExtraUnit();
        }
        this.reserveId(0);
        this.extras((int)0).isUsed = true;
        this.units.get(0).setOffset(1);
        this.units.get(0).setLabel((byte)0);
        if (dawg.child(dawg.root()) != 0) {
            this.buildFromDAWG(dawg, dawg.root(), 0);
        }
        this.fixAllBlocks();
        this.extras = null;
        this.labels = null;
        this.table = null;
    }

    void buildFromDAWG(DAWGBuilder dawg, int dawgId, int dicId) {
        int intersectionId;
        int offset;
        int dawgChildId = dawg.child(dawgId);
        if (dawg.isIntersection(dawgChildId) && (offset = this.table[intersectionId = dawg.intersectionId(dawgChildId)]) != 0 && (((offset ^= dicId) & 0x1FE00000) == 0 || (offset & 0xFF) == 0)) {
            if (dawg.isLeaf(dawgChildId)) {
                this.units.get(dicId).setHasLeaf(true);
            }
            this.units.get(dicId).setOffset(offset);
            return;
        }
        int offset2 = this.arrangeFromDAWG(dawg, dawgId, dicId);
        if (dawg.isIntersection(dawgChildId)) {
            this.table[dawg.intersectionId((int)dawgChildId)] = offset2;
        }
        do {
            byte childLabel = dawg.label(dawgChildId);
            int dicChildId = offset2 ^ Byte.toUnsignedInt(childLabel);
            if (childLabel == 0) continue;
            this.buildFromDAWG(dawg, dawgChildId, dicChildId);
        } while ((dawgChildId = dawg.sibling(dawgChildId)) != 0);
    }

    int arrangeFromDAWG(DAWGBuilder dawg, int dawgId, int dicId) {
        this.labels.clear();
        int dawgChildId = dawg.child(dawgId);
        while (dawgChildId != 0) {
            this.labels.add(dawg.label(dawgChildId));
            dawgChildId = dawg.sibling(dawgChildId);
        }
        int offset = this.findValidOffset(dicId);
        this.units.get(dicId).setOffset(dicId ^ offset);
        dawgChildId = dawg.child(dawgId);
        for (byte l : this.labels) {
            int dicChildId = offset ^ Byte.toUnsignedInt(l);
            this.reserveId(dicChildId);
            if (dawg.isLeaf(dawgChildId)) {
                this.units.get(dicId).setHasLeaf(true);
                this.units.get(dicChildId).setValue(dawg.value(dawgChildId));
            } else {
                this.units.get(dicChildId).setLabel(l);
            }
            dawgChildId = dawg.sibling(dawgChildId);
        }
        this.extras((int)offset).isUsed = true;
        return offset;
    }

    void buildFromKeySet(KeySet keySet) {
        int numUnits;
        for (numUnits = 1; numUnits < keySet.size(); numUnits <<= 1) {
        }
        this.units.ensureCapacity(numUnits);
        this.extras = new DoubleArrayBuilderExtraUnit[4096];
        for (int i = 0; i < this.extras.length; ++i) {
            this.extras[i] = new DoubleArrayBuilderExtraUnit();
        }
        this.reserveId(0);
        this.extras((int)0).isUsed = true;
        this.units.get(0).setOffset(1);
        this.units.get(0).setLabel((byte)0);
        if (keySet.size() > 0) {
            this.buildFromKeySet(keySet, 0, keySet.size(), 0, 0);
        }
        this.fixAllBlocks();
        this.extras = null;
        this.labels = null;
    }

    void buildFromKeySet(KeySet keySet, int begin, int end, int depth, int dicId) {
        int offset = this.arrangeFromKeySet(keySet, begin, end, depth, dicId);
        while (begin < end && keySet.getKeyByte(begin, depth) == 0) {
            ++begin;
        }
        if (begin == end) {
            return;
        }
        int lastBegin = begin;
        byte lastLabel = keySet.getKeyByte(begin, depth);
        while (++begin < end) {
            byte label = keySet.getKeyByte(begin, depth);
            if (label == lastLabel) continue;
            this.buildFromKeySet(keySet, lastBegin, begin, depth + 1, offset ^ Byte.toUnsignedInt(lastLabel));
            lastBegin = begin;
            lastLabel = keySet.getKeyByte(begin, depth);
        }
        this.buildFromKeySet(keySet, lastBegin, end, depth + 1, offset ^ Byte.toUnsignedInt(lastLabel));
    }

    int arrangeFromKeySet(KeySet keySet, int begin, int end, int depth, int dicId) {
        this.labels.clear();
        int value = -1;
        for (int i = begin; i < end; ++i) {
            byte label = keySet.getKeyByte(i, depth);
            if (label == 0) {
                if (depth < keySet.getKey(i).length) {
                    throw new IllegalArgumentException("invalid null character");
                }
                if (keySet.getValue(i) < 0) {
                    throw new IllegalArgumentException("negative value");
                }
                if (value == -1) {
                    value = keySet.getValue(i);
                }
                if (this.progressFunction != null) {
                    this.progressFunction.accept(i + 1, keySet.size() + 1);
                }
            }
            if (this.labels.isEmpty()) {
                this.labels.add(label);
                continue;
            }
            if (label == this.labels.get(this.labels.size() - 1)) continue;
            if (Byte.toUnsignedInt(label) < Byte.toUnsignedInt(this.labels.get(this.labels.size() - 1))) {
                throw new IllegalArgumentException("wrong key order");
            }
            this.labels.add(label);
        }
        int offset = this.findValidOffset(dicId);
        this.units.get(dicId).setOffset(dicId ^ offset);
        for (byte l : this.labels) {
            int dicChildId = offset ^ Byte.toUnsignedInt(l);
            this.reserveId(dicChildId);
            if (l == 0) {
                this.units.get(dicId).setHasLeaf(true);
                this.units.get(dicChildId).setValue(value);
                continue;
            }
            this.units.get(dicChildId).setLabel(l);
        }
        this.extras((int)offset).isUsed = true;
        return offset;
    }

    int findValidOffset(int id) {
        if (this.extrasHead >= this.units.size()) {
            return this.units.size() | id & 0xFF;
        }
        int unfixedId = this.extrasHead;
        do {
            int offset;
            if (!this.isValidOffset(id, offset = unfixedId ^ Byte.toUnsignedInt(this.labels.get(0)))) continue;
            return offset;
        } while ((unfixedId = this.extras((int)unfixedId).next) != this.extrasHead);
        return this.units.size() | id & 0xFF;
    }

    boolean isValidOffset(int id, int offset) {
        if (this.extras((int)offset).isUsed) {
            return false;
        }
        int relOffset = id ^ offset;
        if ((relOffset & 0xFF) != 0 && (relOffset & 0x1FE00000) != 0) {
            return false;
        }
        for (int i = 1; i < this.labels.size(); ++i) {
            if (!this.extras((int)(offset ^ Byte.toUnsignedInt((byte)this.labels.get((int)i).byteValue()))).isFixed) continue;
            return false;
        }
        return true;
    }

    void reserveId(int id) {
        if (id >= this.units.size()) {
            this.expandUnits();
        }
        if (id == this.extrasHead) {
            this.extrasHead = this.extras((int)id).next;
            if (this.extrasHead == id) {
                this.extrasHead = this.units.size();
            }
        }
        this.extras((int)this.extras((int)id).prev).next = this.extras((int)id).next;
        this.extras((int)this.extras((int)id).next).prev = this.extras((int)id).prev;
        this.extras((int)id).isFixed = true;
    }

    void expandUnits() {
        int i;
        int srcNumUnits = this.units.size();
        int srcNumBlocks = this.numBlocks();
        int destNumUnits = srcNumUnits + 256;
        int destNumBlocks = srcNumBlocks + 1;
        if (destNumBlocks > 16) {
            this.fixBlock(srcNumBlocks - 16);
        }
        for (i = srcNumUnits; i < destNumUnits; ++i) {
            this.units.add(new DoubleArrayBuilderUnit());
        }
        if (destNumBlocks > 16) {
            for (int id = srcNumUnits; id < destNumUnits; ++id) {
                this.extras((int)id).isUsed = false;
                this.extras((int)id).isFixed = false;
            }
        }
        for (i = srcNumUnits + 1; i < destNumUnits; ++i) {
            this.extras((int)(i - 1)).next = i;
            this.extras((int)i).prev = i - 1;
        }
        this.extras((int)srcNumUnits).prev = destNumUnits - 1;
        this.extras((int)(destNumUnits - 1)).next = srcNumUnits;
        this.extras((int)srcNumUnits).prev = this.extras((int)this.extrasHead).prev;
        this.extras((int)(destNumUnits - 1)).next = this.extrasHead;
        this.extras((int)this.extras((int)this.extrasHead).prev).next = srcNumUnits;
        this.extras((int)this.extrasHead).prev = destNumUnits - 1;
    }

    void fixAllBlocks() {
        int begin = 0;
        if (this.numBlocks() > 16) {
            begin = this.numBlocks() - 16;
        }
        int end = this.numBlocks();
        for (int blockId = begin; blockId != end; ++blockId) {
            this.fixBlock(blockId);
        }
    }

    void fixBlock(int blockId) {
        int begin = blockId * 256;
        int end = begin + 256;
        int unusedOffset = 0;
        for (int offset = begin; offset != end; ++offset) {
            if (this.extras((int)offset).isUsed) continue;
            unusedOffset = offset;
            break;
        }
        for (int id = begin; id != end; ++id) {
            if (this.extras((int)id).isFixed) continue;
            this.reserveId(id);
            this.units.get(id).setLabel((byte)(id ^ unusedOffset));
        }
    }

    static class DoubleArrayBuilderExtraUnit {
        int prev;
        int next;
        boolean isFixed;
        boolean isUsed;

        DoubleArrayBuilderExtraUnit() {
        }
    }
}

