/*
 * Decompiled with CFR 0.152.
 */
package com.worksap.nlp.dartsclone.details;

import java.util.ArrayList;

class BitVector {
    private static final int UNIT_SIZE = 32;
    private ArrayList<Integer> units = new ArrayList();
    private int[] ranks;
    private int numOnes;
    private int size;

    BitVector() {
    }

    boolean get(int id) {
        return (this.units.get(id / 32) >>> id % 32 & 1) == 1;
    }

    int rank(int id) {
        int unitId = id / 32;
        return this.ranks[unitId] + this.popCount(this.units.get(unitId) & -1 >>> 32 - id % 32 - 1);
    }

    void set(int id, boolean bit) {
        if (bit) {
            this.units.set(id / 32, this.units.get(id / 32) | 1 << id % 32);
        } else {
            this.units.set(id / 32, this.units.get(id / 32) & ~(1 << id % 32));
        }
    }

    boolean isEmpty() {
        return this.units.isEmpty();
    }

    int numOnes() {
        return this.numOnes;
    }

    int size() {
        return this.size;
    }

    void append() {
        if (this.size % 32 == 0) {
            this.units.add(0);
        }
        ++this.size;
    }

    void build() {
        this.ranks = new int[this.units.size()];
        this.numOnes = 0;
        for (int i = 0; i < this.units.size(); ++i) {
            this.ranks[i] = this.numOnes;
            this.numOnes += this.popCount(this.units.get(i));
        }
    }

    void clear() {
        this.units.clear();
        this.ranks = null;
    }

    private int popCount(int unit) {
        unit = ((unit & 0xAAAAAAAA) >>> 1) + (unit & 0x55555555);
        unit = ((unit & 0xCCCCCCCC) >>> 2) + (unit & 0x33333333);
        unit = (unit >>> 4) + unit & 0xF0F0F0F;
        unit += unit >>> 8;
        unit += unit >>> 16;
        return unit & 0xFF;
    }
}

