/*
 * Decompiled with CFR 0.152.
 */
package com.worklab.social_gateway;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import com.facebook.AccessToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import com.worklab.social_gateway.IAuthentication;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SimpleFacebookActivity
extends AppCompatActivity
implements IAuthentication {
    private CallbackManager mCallbackManager;
    private AccessToken mAccessToken;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        FacebookSdk.sdkInitialize((Context)this.getApplicationContext());
        this.mCallbackManager = CallbackManager.Factory.create();
        LoginManager.getInstance().registerCallback(this.mCallbackManager, (FacebookCallback)new FacebookCallback<LoginResult>(){

            public void onSuccess(LoginResult loginResult) {
                SimpleFacebookActivity.this.mAccessToken = AccessToken.getCurrentAccessToken();
            }

            public void onCancel() {
                SimpleFacebookActivity.this.mAccessToken = null;
            }

            public void onError(FacebookException error) {
                SimpleFacebookActivity.this.mAccessToken = null;
            }
        });
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.mCallbackManager.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public final void doLogin() {
        this.doLoginWithReadMode(Arrays.asList("public_profile"));
    }

    @Override
    public final void doLoginWithReadMode(List<String> pPermissions) {
        LoginManager.getInstance().logInWithReadPermissions((Activity)this, pPermissions);
    }

    @Override
    public final void doLoginWithPublishMode(List<String> pPermissions) {
        LoginManager.getInstance().logInWithPublishPermissions((Activity)this, pPermissions);
    }

    @Override
    public void doLogout() {
        if (this.mAccessToken != null) {
            LoginManager.getInstance().logOut();
        }
    }

    @Override
    public boolean isLogged() {
        return this.mAccessToken != null;
    }

    @Override
    public List<String> getCurrentPermissions() {
        if (this.isLogged()) {
            return new ArrayList<String>(this.mAccessToken.getPermissions());
        }
        return null;
    }
}

