package com.ec.v2.entity.statistics.parmas;

import lombok.Data;

import java.util.List;

/**
 * 
 * @Title: CrmQuantityParam.java
 * @Description: 客户数量分析
 * @author shicy
 * @date 2020-04-13 04:17:46
 */
@Data
public class CrmQuantityParam extends BaseParam{
	
	/**  
	 * @Fields serialVersionUID : TODO
	 * @author shicy
	 * @date 2020-04-13 04:21:30 
	 */
	private static final long serialVersionUID = 1L;
	private Integer isDefault;
	
	/**
	 * 标签查询类型 <br/>  
	 * 1:不限  <br/> 
	 * 2:选择标签 <br/>  
	 * 3:无标签 <br/> 
	 */
	private Integer tagsType;
	
	/**
	 * 标签列表<br/> 
	 * 如果tagsType=2， 那么tags 不能为空 
	 */
	private List<Long> tags;
	
	/**
	 *  流失类型 【200 全部 201 放弃到公海，202 转让给同事，203 删除客户，204 合并客户】<br/> 
	 *  如果查询的是 流失客户数 相关指标， 这个参数起作用
	 */
	private List<Integer> wastageType;
 
	/**
	 * 入库类型 【100 全部、101 新增客户，102 同事转入，103 分配客户，104 回收站还原， 105 公海领取，106 合并客户】<br/> 
	 * 如果查询的是 入库客户数 相关指标， 这个参数起作用
	 */
	private List<Integer> inStorageType;
    

	
	
	
}
