package com.ec.v2.entity.record;

/**
 * @ClassName: TelRecordHistoryRequest
 * @Description: 请求实体
 * @author longqingping
 * @date 2017年1月5日 上午10:28:31
 */
public class TelRecordHistoryRequest extends TelRecordCommonRequest {

    // private String deptIds;// 否 String 部门ID，希望导出的操作员工所在部门ID，可输入多个值，用分号(;)隔开。
    // private String userIds;// 否 String 员工ID，希望导出的操作员工ID，可输入多个值，用分号(;)隔开。
    // private String crmIds;// 否 String 客户ID，被呼叫的客户的ID，可输入多个值，用分号(;)隔开。
    private Integer year;// 是 Integer 统计时间年，如：2016 取值[1997-当年]
    private Integer month;// 是 Integer 统计时间月，如：01 取值[01-12]
    private Integer startDayOfMonth;// 否 Integer 统计时间开始日，如：01 取值[01-31] 不填默认取01
    private Integer endDayOfMonth;// 否 Integer 统计时间结束日，如：01 取值[01-31]
                                  // 不填默认取至当月最后一天
    private String phoneNo;// 否 String 被呼叫的电话号码，只能查单个电话。
    private Integer pageNo;// 否 int 分页请求时当前请求第几页的数据，从1开始。

    private String startDate;// 统计开始时间
    private String endDate;// 统计结束时间

    public void init() {
        // yyyy-MM-dd hh:mm:ss
        String year_month = this.year + getDateString(this.month);
        this.startDate = year_month + getDateString(this.startDayOfMonth)+ " 00:00:00";
        this.endDate = year_month + getDateString(this.endDayOfMonth)+ " 23:59:59";
    }
    private String getDateString(int monthOrDay){
        return monthOrDay < 10 ? "-0" + monthOrDay :"-"+monthOrDay;
    }
    // public String getDeptIds() {
    // return deptIds;
    // }
    //
    // public void setDeptIds(String deptIds) {
    // this.deptIds = deptIds;
    // }
    //
    // public String getUserIds() {
    // return userIds;
    // }
    //
    // public void setUserIds(String userIds) {
    // this.userIds = userIds;
    // }
    //
    // public String getCrmIds() {
    // return crmIds;
    // }
    //
    // public void setCrmIds(String crmIds) {
    // this.crmIds = crmIds;
    // }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public Integer getMonth() {
        return month;
    }

    public void setMonth(Integer month) {
        this.month = month;
    }

    public Integer getStartDayOfMonth() {
        return startDayOfMonth;
    }

    public void setStartDayOfMonth(Integer startDayOfMonth) {
        this.startDayOfMonth = startDayOfMonth;
    }

    public Integer getEndDayOfMonth() {
        return endDayOfMonth;
    }

    public void setEndDayOfMonth(Integer endDayOfMonth) {
        this.endDayOfMonth = endDayOfMonth;
    }

    public String getPhoneNo() {
        return phoneNo;
    }

    public void setPhoneNo(String phoneNo) {
        this.phoneNo = phoneNo;
    }

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

}
