package com.ec.v2.entity.customer.highquery;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;



import lombok.Data;

@Data
public class HighQueryRep implements Serializable {
	/**  
	 * @Fields serialVersionUID : TODO
	 * @author shicy
	 * @date 2020-04-10 10:54:34 
	 */
	private static final long serialVersionUID = 1L;
	private Long f_corp_id;
	/**
	 * 下一次查询，应该从某个文字开始查询
	 */
	private Integer next_pages_from = 200;
	
	/**
	 * 当前查询到的数据, 对应 list.size 
	 */
	private Integer dataLen = 0;
	
	/**
	 * 总数据: 不考虑分页情况下，所命中的总数据，通常用于分页条
	 */
	private Integer total = 0;
	
	/**
	 * 下面的参数，如果保存，则返回结果
	 */
	private Boolean error = false;
	private String errorMsg;

	/**
	 * 查询到的实际数据
	 */
	private List<Map<String,Object>> data = new ArrayList<Map<String,Object>>();

	/**
	 *
	 * 用于打印日志
	 * @return
	 */
	public Map<String,Object> getSimpleString(){
		Map<String,Object> map = new HashMap<>();
		map.put("f_corp_id",f_corp_id);
		map.put("next_pages_from",next_pages_from);
		map.put("dataLen",dataLen);
		map.put("total",total);
		map.put("error",error);
		map.put("errorMsg",errorMsg);
		return map;
	}

}
