package com.ec.v2.entity.customer;

import java.util.Collections;
import java.util.List;

public class CrmVisitQueryBean {
	private long corpId;
	private List<Long> userIds;
	private List<Long> deptIds;
	private String endDate;
	private String startDate;
	private long endTime;
	private long startTime;
	private int pageNo;
	private int pageSize = 50;
	public CrmVisitQueryBean() {
		userIds = Collections.emptyList();
		deptIds = Collections.emptyList();
	}
	
	public long getCorpId() {
		return corpId;
	}
	public void setCorpId(long corpId) {
		this.corpId = corpId;
	}
	public List<Long> getUserIds() {
		return userIds;
	}
	public void setUserIds(List<Long> userIds) {
		if ( userIds == null ) return ;
		this.userIds = userIds;
	}
	public List<Long> getDeptIds() {
		return deptIds;
	}
	public void setDeptIds(List<Long> departmentIds) {
		if ( departmentIds == null ) return ;
		this.deptIds = departmentIds;
	}

	public int getPageNo() {
		return (pageNo - 1) * pageSize;
	}
	public void setPageNo(int pageNo) {
		if(pageNo <= 0){
			pageNo = 1;
		}
		this.pageNo = pageNo;
	}
	public int getPageSize() {
		return pageSize;
	}	
	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}

	public String getEndDate() {
		return endDate;
	}

	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}

	public long getEndTime() {
		return endTime;
	}

	public void setEndTime(long endTime) {
		this.endTime = endTime;
	}

	public long getStartTime() {
		return startTime;
	}

	public void setStartTime(long startTime) {
		this.startTime = startTime;
	}

	public String getStartDate() {
		return startDate;
	}

	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}

	@Override
	public String toString() {
		return "CrmVisitQueryBean{" +
				"corpId=" + corpId +
				", userIds=" + userIds +
				", deptIds=" + deptIds +
				", endDate='" + endDate + '\'' +
				", startDate='" + startDate + '\'' +
				", endTime=" + endTime +
				", startTime=" + startTime +
				", pageNo=" + pageNo +
				", pageSize=" + pageSize +
				'}';
	}
}
