/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import com.workday.elasticrypt.KeyProvider;
import com.workday.elasticrypt.translog.EncryptedFileChannel;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.index.translog.ChecksummedTranslogStream;
import org.elasticsearch.index.translog.TranslogCorruptedException;
import org.elasticsearch.index.translog.TruncatedTranslogException;
import scala.reflect.ScalaSignature;
import sun.nio.ch.ChannelInputStream;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\u0001\u0003\u0001-\u0011q#\u00128def\u0004H/\u001a3Ue\u0006t7\u000f\\8h'R\u0014X-Y7\u000b\u0005\r!\u0011\u0001\u0003;sC:\u001cHn\\4\u000b\u0005\u00151\u0011!B5oI\u0016D(BA\u0004\t\u00035)G.Y:uS\u000e\u001cX-\u0019:dQ*\t\u0011\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011QBD\u0007\u0002\u0005%\u0011qB\u0001\u0002\u001a\u0007\",7m[:v[6,G\r\u0016:b]NdwnZ*ue\u0016\fW\u000e\u0003\u0005\u0012\u0001\t\u0005\t\u0015!\u0003\u0013\u0003!\u0001\u0018mZ3TSj,\u0007CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"aA%oi\"A\u0011\u0004\u0001B\u0001B\u0003%!$A\u0006lKf\u0004&o\u001c<jI\u0016\u0014\bCA\u000e#\u001b\u0005a\"BA\u000f\u001f\u0003-)G.Y:uS\u000e\u0014\u0018\u0010\u001d;\u000b\u0005}\u0001\u0013aB<pe.$\u0017-\u001f\u0006\u0002C\u0005\u00191m\\7\n\u0005\rb\"aC&fsB\u0013xN^5eKJD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\nS:$W\r\u001f(b[\u0016\u0004\"a\n\u0016\u000f\u0005MA\u0013BA\u0015\u0015\u0003\u0019\u0001&/\u001a3fM&\u00111\u0006\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%\"\u0002\"\u0002\u0018\u0001\t\u0003y\u0013A\u0002\u001fj]&$h\b\u0006\u00031cI\u001a\u0004CA\u0007\u0001\u0011\u0015\tR\u00061\u0001\u0013\u0011\u0015IR\u00061\u0001\u001b\u0011\u0015)S\u00061\u0001'\u0011\u0019)\u0004\u0001)A\u0005m\u00051An\\4hKJ\u0004\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\u000f1|wmZ5oO*\u00111HB\u0001\u0007G>lWn\u001c8\n\u0005uB$\u0001C#T\u0019><w-\u001a:\t\u000b}\u0002A\u0011\t!\u0002\u0017]\u0014\u0018\u000e^3IK\u0006$WM\u001d\u000b\u0003%\u0005CQA\u0011 A\u0002\r\u000bqa\u00195b]:,G\u000e\u0005\u0002E\u00176\tQI\u0003\u0002G\u000f\u0006A1\r[1o]\u0016d7O\u0003\u0002I\u0013\u0006\u0019a.[8\u000b\u0003)\u000bAA[1wC&\u0011A*\u0012\u0002\f\r&dWm\u00115b]:,G\u000e\u0003\u0004O\u0001\u0011\u0005!aT\u0001\u001dGJ,\u0017\r^3J]B,Ho\u0015;sK\u0006l7\u000b\u001e:fC6Le\u000e];u)\t\u0001\u0006\f\u0005\u0002R-6\t!K\u0003\u0002T)\u000611\u000f\u001e:fC6T!!\u0016\u001e\u0002\u0005%|\u0017BA,S\u0005YIe\u000e];u'R\u0014X-Y7TiJ,\u0017-\\%oaV$\b\"B-N\u0001\u0004Q\u0016\u0001G3oGJL\b\u000f^3e\r&dW-\u00138qkR\u001cFO]3b[B\u00111,Y\u0007\u00029*\u0011QLX\u0001\u0003G\"T!\u0001S0\u000b\u0003\u0001\f1a];o\u0013\t\u0011GL\u0001\nDQ\u0006tg.\u001a7J]B,Ho\u0015;sK\u0006l\u0007fA'eYB\u00191#Z4\n\u0005\u0019$\"A\u0002;ie><8\u000f\u0005\u0002iU6\t\u0011N\u0003\u0002V\u0013&\u00111.\u001b\u0002\f\u0013>+\u0005pY3qi&|g.M\u0003\u001fM5\fi!\r\u0004$]J\f\u0019a]\u000b\u0003_B,\u0012A\n\u0003\u0006c*\u0011\rA\u001e\u0002\u0002)&\u00111\u000f^\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u000b\u0005U$\u0012A\u0002;ie><8/\u0005\u0002xuB\u00111\u0003_\u0005\u0003sR\u0011qAT8uQ&tw\r\u0005\u0002|}:\u00111\u0003`\u0005\u0003{R\tq\u0001]1dW\u0006<W-C\u0002\u0000\u0003\u0003\u0011\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005u$\u0012\u0007C\u0012\u0002\u0006\u0005\u001d\u0011\u0011B;\u000f\u0007M\t9!\u0003\u0002v)E*!e\u0005\u000b\u0002\f\t)1oY1mCF\u0012ae\u001a\u0015\u0006\u001b\u0006E\u0011\u0011\u0004\t\u0005'\u0015\f\u0019\u0002E\u0002i\u0003+I1!a\u0006j\u00051)uJR#yG\u0016\u0004H/[8oc\u0019qb%a\u0007\u0002\"E21E\u001c:\u0002\u001eM\f\u0004bIA\u0003\u0003\u000f\ty\"^\u0019\u0006EM!\u00121B\u0019\u0004M\u0005M\u0001bBA\u0013\u0001\u0011\u0005\u0013qE\u0001\n_B,g.\u00138qkR$B!!\u000b\u00020A\u0019\u0011+a\u000b\n\u0007\u00055\"KA\u0006TiJ,\u0017-\\%oaV$\b\u0002CA\u0019\u0003G\u0001\r!a\r\u0002\u0019Q\u0014\u0018M\\:m_\u001e4\u0015\u000e\\3\u0011\u0007!\f)$C\u0002\u00028%\u0014AAR5mK\u0002")
public class EncryptedTranslogStream
extends ChecksummedTranslogStream {
    private final int pageSize;
    private final KeyProvider keyProvider;
    private final String indexName;
    private final ESLogger logger;

    public int writeHeader(FileChannel channel) {
        return 0;
    }

    public InputStreamStreamInput createInputStreamStreamInput(ChannelInputStream encryptedFileInputStream) throws EOFException, IOException {
        return new InputStreamStreamInput((InputStream)encryptedFileInputStream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StreamInput openInput(File translogFile) {
        InputStreamStreamInput inputStreamStreamInput;
        block6: {
            ChannelInputStream encryptedFileInputStream = new ChannelInputStream(new EncryptedFileChannel(translogFile, this.pageSize, this.keyProvider, this.indexName));
            boolean success = false;
            try {
                InputStreamStreamInput in = this.createInputStreamStreamInput(encryptedFileInputStream);
                success = true;
                inputStreamStreamInput = in;
                if (success) break block6;
            }
            catch (IOException iOException) {
                try {
                    throw new TranslogCorruptedException("translog header corrupted", (Throwable)iOException);
                    catch (EOFException eOFException) {
                        throw new TruncatedTranslogException("translog header truncated", (Throwable)eOFException);
                    }
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{encryptedFileInputStream});
                    }
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{encryptedFileInputStream});
        }
        return inputStreamStreamInput;
    }

    public EncryptedTranslogStream(int pageSize, KeyProvider keyProvider, String indexName) {
        this.pageSize = pageSize;
        this.keyProvider = keyProvider;
        this.indexName = indexName;
        this.logger = ESLoggerFactory.getRootLogger();
    }
}

