/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import com.workday.elasticrypt.KeyProvider;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.lucene.util.FileHeader;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;

public class AESWriter {
    private static final int BLOCKSIZE = 16;
    private final Object lock = new Object();
    private RandomAccessFile raf;
    private final Cipher ecipher;
    private final Cipher dcipher;
    private final byte[] buffer;
    private byte[] ciphertext;
    private byte[] cur_iv;
    private long header_offset = 0L;
    private int buffer_pos;
    private long buffer_start;
    private int buffer_size;
    private long end;
    private boolean isPadded;
    private SecretKeySpec key;
    private String indexName;
    private KeyGenerator ivgen;
    private final int page_size;
    private final long page_size_in_bytes;
    private long cur_fp;
    private boolean modified;
    private final String name;
    private Boolean headerWritten = false;
    private final KeyProvider keyProvider;
    private FileHeader fileHeader;
    private boolean force;
    private final ESLogger logger = ESLoggerFactory.getRootLogger();

    public AESWriter(String string, RandomAccessFile randomAccessFile, int n, KeyProvider keyProvider, String string2, FileHeader fileHeader) throws Exception {
        try {
            this.name = string;
            this.raf = randomAccessFile;
            this.keyProvider = keyProvider;
            this.indexName = string2;
            this.fileHeader = fileHeader;
            if (randomAccessFile.length() != 0L) {
                throw new RuntimeException("File already Exists");
            }
            this.ecipher = Cipher.getInstance("AES/CBC/NoPadding");
            this.dcipher = Cipher.getInstance("AES/CBC/NoPadding");
            this.page_size = n;
            this.page_size_in_bytes = 16 * this.page_size;
            this.buffer = new byte[16 * n];
            this.ciphertext = new byte[this.buffer.length];
            this.isPadded = false;
        }
        catch (Exception exception) {
            this.raf.close();
            throw exception;
        }
    }

    private synchronized void writeFileHeaderLazy() throws IOException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException {
        try {
            if (!this.headerWritten.booleanValue()) {
                this.header_offset = this.fileHeader.writeHeader();
                this.key = this.keyProvider.getKey(this.indexName);
                this.ivgen = KeyGenerator.getInstance("AES");
                this.initCiphers(this.generateIV());
                this.headerWritten = true;
            }
        }
        catch (Exception exception) {
            this.raf.close();
            throw exception;
        }
    }

    private IvParameterSpec generateIV() {
        return new IvParameterSpec(this.ivgen.generateKey().getEncoded());
    }

    private void initCiphers(IvParameterSpec ivParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (ivParameterSpec == null) {
            ivParameterSpec = this.generateIV();
        }
        this.cur_iv = ivParameterSpec.getIV();
        this.ecipher.init(1, (Key)this.key, ivParameterSpec);
        this.dcipher.init(2, (Key)this.key, ivParameterSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isPadded || this.modified) {
                this.writePage(true, true);
            }
            if (!this.isPadded) {
                throw new RuntimeException("NO PADDING: this.end=" + this.end + ";this.cur_fp=" + this.cur_fp + ";this.buffer_size=" + this.buffer_size + ";this.buffer_pos=" + this.buffer_pos + ";this.buffer_start=" + this.buffer_start + ";this.force=" + this.force);
            }
            this.raf.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        Object object = this.lock;
        synchronized (object) {
            this.writePage(true, false);
        }
    }

    public long getFilePointer() throws IOException {
        return this.cur_fp;
    }

    public long length() throws IOException {
        return this.end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seek(long l) throws IOException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        Object object = this.lock;
        synchronized (object) {
            this._seek(l);
        }
    }

    private void _seek(long l) throws IOException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        this.writePage(true, false);
        long l2 = this.encryptedAddrToPhysicalAddr(l);
        long l3 = l2 / (this.page_size_in_bytes + 16L);
        this.offset_seek(l3 *= this.page_size_in_bytes + 16L);
        this.cur_fp = l;
        this.fillBuffer();
        this.buffer_start = l / this.page_size_in_bytes * this.page_size_in_bytes;
        this.buffer_pos = (int)(this.cur_fp % this.page_size_in_bytes);
    }

    private void offset_seek(long l) throws IOException {
        this.raf.seek(l + this.header_offset);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException, ShortBufferException, IllegalBlockSizeException, InvalidKeyException, InvalidAlgorithmParameterException, BadPaddingException, NoSuchAlgorithmException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        this.write(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer byteBuffer) throws IOException, ShortBufferException, IllegalBlockSizeException, InvalidKeyException, InvalidAlgorithmParameterException, BadPaddingException, NoSuchAlgorithmException {
        int n = 0;
        Object object = this.lock;
        synchronized (object) {
            while (byteBuffer.hasRemaining()) {
                this.modified = true;
                int n2 = byteBuffer.limit() - byteBuffer.position();
                int n3 = (int)Math.min((long)n2, this.page_size_in_bytes - (long)this.buffer_pos);
                byteBuffer.get(this.buffer, this.buffer_pos, n3);
                if (this.cur_fp + (long)n3 > this.end) {
                    this.isPadded = false;
                }
                n += n3;
                this.buffer_pos += n3;
                this.cur_fp += (long)n3;
                this.buffer_size = Math.max(this.buffer_size, this.buffer_pos);
                this.end = Math.max(this.cur_fp, this.end);
                if ((long)this.buffer_pos != this.page_size_in_bytes) continue;
                this.writePage();
                this.fillBuffer();
            }
        }
        return n;
    }

    private void writePage() throws IOException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        this.writePage(false, false);
    }

    private void writePage(boolean bl, boolean bl2) throws IOException, ShortBufferException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        if (bl2 && !this.headerWritten.booleanValue()) {
            if (this.buffer_size == 0) {
                this.isPadded = true;
                return;
            }
            this.logger.info("Attempting to close file with non-empty buffer and no header written. Will attempt to write header one last time. file: " + this.name + ", buffer_size: " + this.buffer_size, new Object[0]);
        }
        this.writeFileHeaderLazy();
        this.modified = false;
        this.offset_seek(this.encryptedAddrToPhysicalAddr(this.buffer_start) - 16L);
        this.raf.write(this.cur_iv);
        int n = (this.buffer_size + 16 - 1) / 16 * 16;
        int n2 = 16 - this.buffer_size % 16;
        if (n2 < 16 && n2 > 0) {
            this.isPadded = true;
            for (int i = this.buffer_size; i < n; ++i) {
                this.buffer[i] = (byte)n2;
            }
        } else if (bl && n2 == 16 && this.cur_fp / this.page_size_in_bytes == this.end / this.page_size_in_bytes && !this.isPadded) {
            for (int i = n; i < n + 16; ++i) {
                this.buffer[i] = 16;
            }
            if (this.page_size_in_bytes - (long)this.buffer_size >= 16L) {
                this.isPadded = true;
                n += 16;
            } else {
                throw new RuntimeException("Page should not be full: " + this.buffer_size);
            }
        }
        this.ecipher.doFinal(this.buffer, 0, n, this.ciphertext, 0);
        this.raf.write(this.ciphertext, 0, n);
    }

    private void fillBuffer() throws IOException, ShortBufferException, IllegalBlockSizeException, InvalidKeyException, InvalidAlgorithmParameterException, BadPaddingException {
        int n;
        byte[] byArray = new byte[16];
        this.buffer_start = this.cur_fp / this.page_size_in_bytes * this.page_size_in_bytes;
        long l = this.encryptedAddrToPhysicalAddr(this.buffer_start) - 16L;
        this.raf.seek(l += this.header_offset);
        if (l >= this.raf.length()) {
            byArray = this.generateIV().getIV();
            this.raf.write(byArray);
        } else {
            this.raf.readFully(byArray);
        }
        l += 16L;
        this.buffer_size = n = this.raf.read(this.buffer, 0, (int)this.page_size_in_bytes);
        if (n == -1) {
            this.buffer_size = 0;
            this.initCiphers(new IvParameterSpec(byArray));
            this.buffer_pos = 0;
            return;
        }
        this.initCiphers(new IvParameterSpec(byArray));
        this.buffer_pos = 0;
        this.dcipher.doFinal(this.buffer, 0, n, this.buffer, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLength(long l) throws IOException, ShortBufferException, BadPaddingException, InvalidKeyException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        Object object = this.lock;
        synchronized (object) {
            this.force = true;
            long l2 = l + 16L - l % 16L;
            int n = (int)(16L - l % 16L);
            long l3 = (l2 + 16L - 1L) / 16L;
            long l4 = (l3 + (long)this.page_size - 1L) / (long)this.page_size;
            this.raf.setLength(l2 + l4 * 16L + this.header_offset);
            this.end = l;
            this.offset_seek(0L);
            this.buffer_start = 0L;
            long l5 = 0L;
            int n2 = 0;
            while ((long)n2 < l4) {
                byte[] byArray;
                if ((this.raf.getFilePointer() - this.header_offset) % (this.page_size_in_bytes + 16L) != 0L) {
                    throw new RuntimeException("Debug::Incorrect file postion;fp=" + this.raf.getFilePointer());
                }
                if ((long)n2 == l4 - 1L) {
                    byArray = this.generateIV().getIV();
                    this.raf.write(byArray);
                    int n3 = (int)(l2 - l5);
                    byte[] byArray2 = new byte[n3];
                    for (int i = n3 - 1; i >= n3 - n; --i) {
                        byArray2[i] = (byte)n;
                    }
                    this.initCiphers(new IvParameterSpec(byArray));
                    this.ecipher.doFinal(byArray2, 0, n3, byArray2, 0);
                    this.raf.write(byArray2);
                    this.isPadded = true;
                    l5 += (long)n3;
                } else {
                    byArray = this.generateIV().getIV();
                    this.raf.write(byArray);
                    this.raf.seek(this.raf.getFilePointer() + this.page_size_in_bytes);
                    l5 += this.page_size_in_bytes;
                }
                ++n2;
            }
            this.offset_seek(0L);
            this.cur_fp = 0L;
            this.buffer_start = 0L;
            this.buffer_pos = 0;
            this.fillBuffer();
        }
    }

    private long numPageIVBlocksAt(long l) {
        return l / (long)this.page_size + 1L;
    }

    private long encryptedAddrToPhysicalAddr(long l) {
        long l2 = l / 16L;
        return (l2 + this.numPageIVBlocksAt(l2)) * 16L + l % 16L;
    }
}

