/*
 * Decompiled with CFR 0.152.
 */
package com.workable.errorhandler;

import com.workable.errorhandler.Action;
import com.workable.errorhandler.ActionEntry;
import com.workable.errorhandler.BlockExecutor;
import com.workable.errorhandler.ExceptionMatcher;
import com.workable.errorhandler.Matcher;
import com.workable.errorhandler.MatcherFactory;
import com.workable.errorhandler.UnknownErrorCodeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ErrorHandler {
    private static ErrorHandler defaultInstance = null;
    private Map<ErrorCodeIdentifier, MatcherFactory> errorCodeMap;
    private List<ActionEntry> actions = new ArrayList<ActionEntry>();
    private List<Action> otherwiseActions = new ArrayList<Action>();
    private List<Action> alwaysActions = new ArrayList<Action>();
    private ThreadLocal<Context> localContext;
    private ErrorHandler parentErrorHandler;

    private ErrorHandler() {
        this.errorCodeMap = new HashMap<ErrorCodeIdentifier, MatcherFactory>();
        this.localContext = new ThreadLocal<Context>(){

            @Override
            protected Context initialValue() {
                return new Context();
            }
        };
    }

    private ErrorHandler(ErrorHandler parentErrorHandler) {
        this();
        this.parentErrorHandler = parentErrorHandler;
    }

    public static ErrorHandler createIsolated() {
        return new ErrorHandler();
    }

    public static ErrorHandler create() {
        return new ErrorHandler(ErrorHandler.defaultErrorHandler());
    }

    public static synchronized ErrorHandler defaultErrorHandler() {
        if (defaultInstance == null) {
            defaultInstance = new ErrorHandler();
        }
        return defaultInstance;
    }

    public ErrorHandler on(Matcher matcher, Action action) {
        if (matcher == null) {
            throw new IllegalArgumentException("matcher cannot be null");
        }
        this.assertNotNullAction(action);
        this.actions.add(ActionEntry.from(matcher, action));
        return this;
    }

    public ErrorHandler on(Class<? extends Exception> exceptionClass, Action action) {
        if (exceptionClass == null) {
            throw new IllegalArgumentException("exceptionClass cannot be null");
        }
        this.assertNotNullAction(action);
        this.actions.add(ActionEntry.from(new ExceptionMatcher(exceptionClass), action));
        return this;
    }

    public <T> ErrorHandler on(T errorCode, Action action) {
        if (errorCode == null) {
            throw new IllegalArgumentException("errorCode cannot be null");
        }
        MatcherFactory<T> matcherFactory = this.getMatcherFactoryForErrorCode(errorCode);
        if (matcherFactory == null) {
            throw new UnknownErrorCodeException(errorCode);
        }
        this.actions.add(ActionEntry.from(matcherFactory.build(errorCode), action));
        return this;
    }

    public ErrorHandler otherwise(Action action) {
        this.assertNotNullAction(action);
        this.otherwiseActions.add(action);
        return this;
    }

    public ErrorHandler always(Action action) {
        this.assertNotNullAction(action);
        this.alwaysActions.add(action);
        return this;
    }

    public ErrorHandler skipFollowing() {
        if (this.localContext != null) {
            this.localContext.get().skipFollowing = true;
        }
        return this;
    }

    public ErrorHandler skipAlways() {
        if (this.localContext != null) {
            this.localContext.get().skipAlways = true;
        }
        return this;
    }

    public ErrorHandler skipDefaults() {
        if (this.localContext != null) {
            this.localContext.get().skipDefaults = true;
        }
        return this;
    }

    protected void handle(Throwable error, ThreadLocal<Context> context) {
        if (error == null) {
            throw new IllegalArgumentException("error to be checked can not be null");
        }
        this.localContext = context;
        Context ctx = this.localContext.get();
        for (ActionEntry actionEntry : this.actions) {
            if (ctx.skipFollowing) break;
            if (!actionEntry.matcher.matches(error)) continue;
            actionEntry.action.execute(error, this);
            ctx.handled = true;
        }
        if (!ctx.handled && !this.otherwiseActions.isEmpty()) {
            for (Action action : this.otherwiseActions) {
                action.execute(error, this);
                ctx.handled = true;
            }
        }
        if (!ctx.skipAlways) {
            for (Action action : this.alwaysActions) {
                action.execute(error, this);
                ctx.handled = true;
            }
        }
        if (this.parentErrorHandler != null && !ctx.skipDefaults) {
            this.parentErrorHandler.handle(error, this.localContext);
        }
    }

    public void run(BlockExecutor blockExecutor) {
        try {
            blockExecutor.invoke();
        }
        catch (Exception exception) {
            this.handle(exception, this.localContext);
        }
    }

    public void handle(Throwable error) {
        this.handle(error, this.localContext);
    }

    public <T> ErrorHandler bind(T errorCode, MatcherFactory<? super T> matcherFactory) {
        this.errorCodeMap.put(new ErrorCodeIdentifier<T>(errorCode), matcherFactory);
        return this;
    }

    public <T> ErrorHandler bindClass(Class<T> errorCodeClass, MatcherFactory<? super T> matcherFactory) {
        this.errorCodeMap.put(new ErrorCodeIdentifier<T>(errorCodeClass), matcherFactory);
        return this;
    }

    protected <T> MatcherFactory<? super T> getMatcherFactoryForErrorCode(T errorCode) {
        MatcherFactory matcherFactory = this.errorCodeMap.get(new ErrorCodeIdentifier<T>(errorCode));
        if (matcherFactory != null) {
            return matcherFactory;
        }
        matcherFactory = this.errorCodeMap.get(new ErrorCodeIdentifier(errorCode.getClass()));
        if (matcherFactory != null) {
            return matcherFactory;
        }
        if (this.parentErrorHandler != null) {
            return this.parentErrorHandler.getMatcherFactoryForErrorCode(errorCode);
        }
        return null;
    }

    public void clear() {
        this.actions.clear();
        this.errorCodeMap.clear();
        this.otherwiseActions.clear();
        this.alwaysActions.clear();
        if (this.localContext != null) {
            this.localContext.get().clear();
        }
    }

    private void assertNotNullAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("action cannot be null");
        }
    }

    private static final class ErrorCodeIdentifier<T> {
        private T errorCode;
        private Class<T> errorCodeClass;

        ErrorCodeIdentifier(T errorCode) {
            this.errorCode = errorCode;
        }

        ErrorCodeIdentifier(Class<T> errorCodeClass) {
            this.errorCodeClass = errorCodeClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ErrorCodeIdentifier that = (ErrorCodeIdentifier)o;
            if (this.errorCode != null ? !this.errorCode.equals(that.errorCode) : that.errorCode != null) {
                return false;
            }
            return this.errorCodeClass != null ? this.errorCodeClass.equals(that.errorCodeClass) : that.errorCodeClass == null;
        }

        public int hashCode() {
            int result = this.errorCode != null ? this.errorCode.hashCode() : 0;
            result = 31 * result + (this.errorCodeClass != null ? this.errorCodeClass.hashCode() : 0);
            return result;
        }
    }

    private static class Context {
        private HashMap<String, Object> keys = new HashMap();
        boolean handled;
        boolean skipDefaults = false;
        boolean skipFollowing = false;
        boolean skipAlways = false;

        private Context() {
        }

        public Object get(Object key) {
            return this.keys.get(key);
        }

        public Object put(String key, Object value) {
            return this.keys.put(key, value);
        }

        public Object remove(Object key) {
            return this.keys.remove(key);
        }

        void clear() {
            this.keys.clear();
            this.skipDefaults = false;
            this.skipFollowing = false;
            this.skipAlways = false;
        }
    }
}

