/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swaggersocket.server;

import com.wordnik.swaggersocket.server.SwaggerSocketProtocolInterceptor;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.atmosphere.client.TrackMessageSizeInterceptor;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerSocketServlet
extends AtmosphereServlet {
    private static final long serialVersionUID = 4402468478554948436L;
    private final Logger logger = LoggerFactory.getLogger(SwaggerSocketServlet.class);

    public SwaggerSocketServlet() {
        this(false);
    }

    public SwaggerSocketServlet(boolean isFilter) {
        this(isFilter, true);
    }

    public SwaggerSocketServlet(boolean isFilter, boolean autoDetectHandlers) {
        super(isFilter, autoDetectHandlers);
        this.framework().addInitParameter("org.atmosphere.useNative", "true");
        this.framework().addInitParameter("com.sun.jersey.api.json.POJOMappingFeature", "true");
        this.framework().addInitParameter("org.atmosphere.cpr.sessionSupport", "true");
    }

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        TrackMessageSizeInterceptor t = new TrackMessageSizeInterceptor();
        t.excludedContentType("application/javascript").excludedContentType("text/html").excludedContentType("text/plain").messageDelimiter("<->");
        t.configure(this.framework().getAtmosphereConfig());
        this.framework().interceptor((AtmosphereInterceptor)t);
        this.framework().interceptor((AtmosphereInterceptor)new SwaggerSocketProtocolInterceptor());
        this.logger.info("Swagger Socket installed {}", (Object)Version.getRawVersion());
    }
}

