/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swaggersocket.samples;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.util.Base64;
import com.sun.jersey.spi.resource.Singleton;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.jersey.SuspendResponse;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/search/{tagid}")
@Produces(value={"text/html;charset=ISO-8859-1"})
@Singleton
public class TwitterFeed {
    private static final Logger logger = LoggerFactory.getLogger(TwitterFeed.class);
    private final AsyncHttpClient asyncClient = new AsyncHttpClient();
    private final ConcurrentHashMap<String, Future<?>> futures = new ConcurrentHashMap();
    private final CountDownLatch suspendLatch = new CountDownLatch(1);
    @Context
    private ServletConfig sc;
    private boolean initialized;
    private String authorizationValue;
    private Exception authorizationException;

    @GET
    public SuspendResponse<String> search(@PathParam(value="tagid") Broadcaster feed, @PathParam(value="tagid") String tagid) {
        if (tagid.isEmpty()) {
            throw new WebApplicationException();
        }
        if (!this.initialized) {
            this.initialized = true;
            String key = this.sc.getInitParameter("com.twitter.consumer.key");
            String secret = this.sc.getInitParameter("com.twitter.consumer.secret");
            try {
                ListenableFuture f = this.asyncClient.preparePost("https://api.twitter.com/oauth2/token").setHeader("Authorization", "Basic " + Base64.encode((byte[])(key + ":" + secret).getBytes())).setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").setBody("grant_type=client_credentials").execute();
                JSONObject jtoken = new JSONObject(((Response)f.get()).getResponseBody());
                this.authorizationValue = "Bearer " + jtoken.getString("access_token");
            }
            catch (Exception e) {
                logger.error("Unable to obtain a valid bearer token", (Throwable)e);
                this.authorizationException = e;
            }
        }
        if (this.authorizationValue == null) {
            throw new WebApplicationException((Throwable)this.authorizationException);
        }
        if (feed.getAtmosphereResources().size() == 0) {
            Future future = feed.scheduleFixedBroadcast((Object)new /* Unavailable Anonymous Inner Class!! */, 4L, TimeUnit.SECONDS);
            this.futures.put(tagid, future);
        }
        return new SuspendResponse.SuspendResponseBuilder().broadcaster(feed).outputComments(true).addListener((AtmosphereResourceEventListener)new /* Unavailable Anonymous Inner Class!! */).build();
    }

    @GET
    @Path(value="/stop")
    public String stopSearch(@PathParam(value="tagid") Broadcaster feed, @PathParam(value="tagid") String tagid) {
        feed.resumeAll();
        if (this.futures.get(tagid) != null) {
            ((Future)this.futures.get(tagid)).cancel(true);
        }
        logger.info("Stopping real time update for {}", (Object)tagid);
        return "";
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ CountDownLatch access$200(TwitterFeed x0) {
        return x0.suspendLatch;
    }

    static /* synthetic */ String access$300(TwitterFeed x0) {
        return x0.authorizationValue;
    }

    static /* synthetic */ AsyncHttpClient access$400(TwitterFeed x0) {
        return x0.asyncClient;
    }
}

