/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swaggersocket.protocol;

import com.wordnik.swaggersocket.protocol.Header;
import com.wordnik.swaggersocket.protocol.ProtocolBase;
import com.wordnik.swaggersocket.protocol.QueryString;
import java.util.List;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class Handshake
extends ProtocolBase {
    private String protocolName = "SwaggerSocket";
    private String protocolVersion = "1.0";
    private String dataFormat = "application/json";

    public Handshake() {
    }

    private Handshake(Builder b) {
        this.protocolName = b.protocolName;
        this.protocolVersion = b.protocolVersion;
        this.dataFormat = b.dataFormat;
        this.headers = b.headers;
        this.queryString = b.queryString;
        this.path = b.path;
        this.uuid = b.uuid;
        this.method = b.method;
        this.dataFormat = b.dataFormat;
        this.messageBody = b.body;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public void setProtocolName(String protocolName) {
        this.protocolName = protocolName;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public static final class Builder {
        private String protocolName = "SwaggerSocket";
        private String protocolVersion = "1.0";
        private String dataFormat = "application/json";
        private List<Header> headers;
        private List<QueryString> queryString;
        private String path;
        private String uuid;
        private String method;
        private Object body;

        public Builder format(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder headers(List<Header> headers) {
            this.headers = headers;
            return this;
        }

        public Builder queryString(List<QueryString> queryString) {
            this.queryString = queryString;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder protocolName(String protocolName) {
            this.protocolName = protocolName;
            return this;
        }

        public Builder protocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public final Builder body(Object messageBody) {
            this.body = messageBody;
            return this;
        }

        public Handshake build() {
            return new Handshake(this);
        }
    }
}

