/*
 * Decompiled with CFR 0.152.
 */
package com.woodblockwithoutco.beretained;

import android.support.v4.app.FragmentActivity;
import com.woodblockwithoutco.beretained.FieldsRetainer;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public final class BeRetained {
    private static final String JAVA_PACKAGE = "java";
    private static final String ANDROID_PACKAGE = "android";
    private static final String FIELDS_RETAINER_SUFFIX = "FieldsRetainer";
    private static final String FIELDS_RETAINER_PACKAGE = "com.woodblockwithoutco.beretained";
    private static final Map<Class<?>, FieldsRetainer<?>> FIELDS_RETAINER_MAP = new HashMap();

    private BeRetained() {
    }

    public static void onCreate(FragmentActivity activity) {
        FieldsRetainer<FragmentActivity> retainer = BeRetained.findFieldsRetainer(activity.getClass());
        if (retainer != null) {
            retainer.onCreate(activity);
        }
    }

    public static void save(FragmentActivity source) {
        FieldsRetainer<FragmentActivity> retainer = BeRetained.findFieldsRetainer(source.getClass());
        if (retainer != null) {
            retainer.save(source);
        }
    }

    public static boolean restore(FragmentActivity target) {
        FieldsRetainer<FragmentActivity> retainer = BeRetained.findFieldsRetainer(target.getClass());
        if (retainer != null) {
            return retainer.restore(target);
        }
        return false;
    }

    private static FieldsRetainer<FragmentActivity> findFieldsRetainer(Class<? extends FragmentActivity> clazz) {
        FieldsRetainer retainer = FIELDS_RETAINER_MAP.get(clazz);
        if (retainer == null) {
            try {
                Class<Object> retainEnabledClass = clazz;
                Class<?> retainerClass = BeRetained.getRetainerClass(retainEnabledClass);
                while (retainerClass == null && retainEnabledClass != null) {
                    if ((retainEnabledClass = BeRetained.getParentClass(retainEnabledClass)) == null) continue;
                    retainerClass = BeRetained.getRetainerClass(retainEnabledClass);
                }
                if (retainerClass == null) {
                    return null;
                }
                retainer = (FieldsRetainer)retainerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                return null;
            }
        }
        if (retainer != null) {
            FIELDS_RETAINER_MAP.put(clazz, retainer);
        }
        return retainer;
    }

    private static Class<?> getParentClass(Class<?> clazz) {
        if (clazz.getName().startsWith(ANDROID_PACKAGE) || clazz.getName().startsWith(JAVA_PACKAGE)) {
            return null;
        }
        return clazz.getSuperclass();
    }

    private static Class<?> getRetainerClass(Class<?> clazz) {
        try {
            return Class.forName("com.woodblockwithoutco.beretained." + clazz.getSimpleName() + FIELDS_RETAINER_SUFFIX);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

