/*
 * Decompiled with CFR 0.152.
 */
package com.woaiqw.scm_api;

import android.app.Application;
import android.content.Context;
import android.util.Log;
import com.woaiqw.annotation.Modules;
import com.woaiqw.scm_api.ScAction;
import com.woaiqw.scm_api.ScCallback;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class SCM {
    private static volatile SCM instance = null;
    private HashMap<String, ScAction> actionMap = new HashMap();
    private AtomicBoolean isReady = new AtomicBoolean(false);

    private SCM() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SCM get() {
        if (instance != null) return instance;
        Class<SCM> clazz = SCM.class;
        synchronized (SCM.class) {
            if (instance != null) return instance;
            instance = new SCM();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void scanningSCMTable(Class<? extends Application> o) {
        Modules annotation = o.getAnnotation(Modules.class);
        String[] moduleNames = annotation.names();
        if (moduleNames.length != 0) {
            for (String moduleName : moduleNames) {
                try {
                    Class<?> clazz = Class.forName("com.woaiqw.scm_api." + moduleName + "SCMTable");
                    Field[] fields = clazz.getFields();
                    if (fields == null || fields.length == 0) continue;
                    for (Field field : fields) {
                        String name = field.getName();
                        String path = (String)field.get(name);
                        ScAction sca = (ScAction)Class.forName(path).newInstance();
                        this.actionMap.put(name, sca);
                    }
                }
                catch (Exception e) {
                    Log.e((String)"SCM_API", (String)e.getMessage());
                }
            }
        } else {
            throw new IllegalStateException(" moduleNames must a exit arr for scanning ");
        }
        this.isReady.set(true);
    }

    public void req(Context context, String actionName, ScCallback callback) throws Exception {
        this.req(context, actionName, null, callback);
    }

    public void req(Context context, String actionName, String param, ScCallback callback) throws Exception {
        if (!this.isReady.get()) {
            throw new RuntimeException("SCM is not ready! pls wait!");
        }
        if (!this.actionMap.containsKey(actionName)) {
            throw new RuntimeException("SCM action not found! name:" + actionName);
        }
        ScAction action = this.actionMap.get(actionName);
        action.invoke(context, param, callback);
    }
}

