package com.wms.network.exception;

import com.wms.network.R;
import com.wms.network.RetrofitManager;
import com.wms.network.baseserver.BaseHttpResult;

import io.reactivex.functions.Function;

/**
 * Created by 王梦思 on 2018/9/10.
 * <p/>
 */
public class ServerException<T> implements Function<BaseHttpResult<T>, T> {
    @Override
    public T apply(BaseHttpResult<T> result) throws Exception {

        if (result != null) {
            if (result.isSuccess()) {
                if (result.getData() != null) {
                    return result.getData();
                }
                throw new ResultEmptyException();
            }

            //处理其他异常结果
            if (result.parseOtherExceptionResult()) {
                throw new ApiException("");
            }
            throw new ApiException(result.getMsg());
        }

        throw new ApiException(RetrofitManager.getString(R.string.wms_network_network_error));
    }
}
