/*
 * Decompiled with CFR 0.152.
 */
package com.wms.logger;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.orhanobut.logger.FormatStrategy;
import com.orhanobut.logger.LogStrategy;
import com.wms.logger.DiskLogStrategy;
import com.wms.logger.Logger;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class MyFormatStrategy
implements FormatStrategy {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String SEPARATOR = " ";
    @NonNull
    private final SimpleDateFormat dateFormat;
    @NonNull
    private final LogStrategy logStrategy;
    @Nullable
    private final String tag;
    boolean showThreadInfo;

    private MyFormatStrategy(@NonNull Builder builder) {
        MyFormatStrategy.checkNotNull(builder);
        this.dateFormat = builder.dateFormat;
        this.logStrategy = builder.logStrategy;
        this.tag = builder.tag;
        this.showThreadInfo = builder.showThreadInfo;
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    public void log(int priority, @Nullable String onceOnlyTag, @NonNull String message) {
        MyFormatStrategy.checkNotNull(message);
        String tag = this.formatTag(onceOnlyTag);
        StringBuilder builder = new StringBuilder();
        builder.append(this.dateFormat.format(System.currentTimeMillis()));
        builder.append(SEPARATOR);
        builder.append(MyFormatStrategy.logLevel(priority));
        builder.append("/");
        builder.append(tag);
        if (this.showThreadInfo) {
            builder.append("/");
            builder.append(Thread.currentThread().getName());
        }
        builder.append(":");
        builder.append(message);
        builder.append(NEW_LINE);
        this.logStrategy.log(priority, tag, builder.toString());
    }

    @Nullable
    private String formatTag(@Nullable String tag) {
        if (!TextUtils.isEmpty((CharSequence)tag) && !tag.equalsIgnoreCase(this.tag)) {
            return this.tag + "-" + tag;
        }
        return this.tag;
    }

    static String logLevel(int value) {
        switch (value) {
            case 2: {
                return "VERBOSE";
            }
            case 3: {
                return "DEBUG";
            }
            case 4: {
                return "INFO";
            }
            case 5: {
                return "WARN";
            }
            case 6: {
                return "ERROR";
            }
            case 7: {
                return "ASSERT";
            }
        }
        return "UNKNOWN";
    }

    @NonNull
    static <T> T checkNotNull(@Nullable T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static final class Builder {
        SimpleDateFormat dateFormat;
        LogStrategy logStrategy;
        String tag = "PRETTY_LOGGER";
        String logPath;
        Context context;
        boolean showThreadInfo;
        @SuppressLint(value={"SimpleDateFormat"})
        SimpleDateFormat logFileFormat = new SimpleDateFormat("yyyy-MM-dd");
        int maxFileSize = 0x100000;

        private Builder() {
        }

        @NonNull
        Builder maxFileSize(int val) {
            this.maxFileSize = val;
            return this;
        }

        @NonNull
        Builder logFileFormat(@Nullable SimpleDateFormat val) {
            this.logFileFormat = val;
            return this;
        }

        @NonNull
        Builder dateFormat(@Nullable SimpleDateFormat val) {
            this.dateFormat = val;
            return this;
        }

        @NonNull
        Builder logStrategy(@Nullable LogStrategy val) {
            this.logStrategy = val;
            return this;
        }

        @NonNull
        Builder tag(@Nullable String tag) {
            this.tag = tag;
            return this;
        }

        @NonNull
        Builder context(@Nullable Context context) {
            this.context = context;
            return this;
        }

        Builder logPath(String logPath) {
            this.logPath = logPath;
            return this;
        }

        Builder showThreadInfo(boolean showThreadInfo) {
            this.showThreadInfo = showThreadInfo;
            return this;
        }

        @NonNull
        MyFormatStrategy build() {
            if (this.dateFormat == null) {
                this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
            }
            if (this.logStrategy == null) {
                String folder = Logger.getLogPath(this.context, this.logPath);
                HandlerThread ht = new HandlerThread("AndroidFileLogger." + folder);
                ht.start();
                DiskLogStrategy.WriteHandler handler = new DiskLogStrategy.WriteHandler(ht.getLooper(), folder, this.logFileFormat, this.maxFileSize);
                this.logStrategy = new DiskLogStrategy(handler);
            }
            return new MyFormatStrategy(this);
        }
    }
}

