/*
 * Decompiled with CFR 0.152.
 */
package com.wms.logger;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.orhanobut.logger.AndroidLogAdapter;
import com.orhanobut.logger.DiskLogAdapter;
import com.orhanobut.logger.FormatStrategy;
import com.orhanobut.logger.LogAdapter;
import com.orhanobut.logger.PrettyFormatStrategy;
import com.wms.logger.MyFormatStrategy;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;

public class Logger {
    private static Logger mInstance;

    private static Logger getInstance(Builder builder) {
        if (mInstance == null) {
            try {
                mInstance = new Logger(builder);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mInstance;
    }

    private Logger(final Builder builder) {
        String[] logs;
        if (builder == null || !builder.isDebug) {
            return;
        }
        com.orhanobut.logger.Logger.clearLogAdapters();
        File logPath = new File(Logger.getLogPath(builder.context, builder.logPath));
        if (builder.saveLogCount > 0 && !TextUtils.isEmpty((CharSequence)logPath.getAbsolutePath()) && logPath.exists() && (logs = logPath.list()) != null && logs.length > 0) {
            try {
                int i;
                long[] logTimes = new long[logs.length];
                for (i = 0; i < logs.length; ++i) {
                    logTimes[i] = builder.logFileFormat.parse(logs[i]).getTime();
                }
                Arrays.sort(logTimes);
                if (logTimes.length > builder.saveLogCount) {
                    for (i = 0; i < logTimes.length - builder.saveLogCount; ++i) {
                        Logger.deleteDir(new File(logPath + File.separator + builder.logFileFormat.format(logTimes[i])));
                    }
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (builder.deleteOnLaunch && builder.saveFile) {
            Logger.deleteDir(logPath);
        }
        PrettyFormatStrategy formatStrategy = PrettyFormatStrategy.newBuilder().showThreadInfo(builder.showThreadInfo).methodCount(builder.methodCount).methodOffset(builder.methodOffset).tag(builder.tag).build();
        com.orhanobut.logger.Logger.addLogAdapter((LogAdapter)new AndroidLogAdapter((FormatStrategy)formatStrategy){

            public boolean isLoggable(int priority, String tag) {
                return builder.isDebug;
            }
        });
        if (builder.saveFile) {
            MyFormatStrategy strategy = MyFormatStrategy.newBuilder().tag(builder.tag).logPath(builder.logPath).context(builder.context).logFileFormat(builder.logFileFormat).showThreadInfo(builder.showThreadInfo).maxFileSize(builder.maxFileSize).build();
            com.orhanobut.logger.Logger.addLogAdapter((LogAdapter)new DiskLogAdapter(strategy){

                public boolean isLoggable(int priority, @Nullable String tag) {
                    return builder.isDebug;
                }
            });
        }
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            for (String aChildren : children = dir.list()) {
                boolean success = Logger.deleteDir(new File(dir, aChildren));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static void i(Object msg) {
        Logger.log(Type.INFO, msg);
    }

    public static void i(Object msg1, Object msg2) {
        Logger.log(Type.INFO, msg1, msg2);
    }

    public static void i(Object msg1, Object msg2, Object msg3) {
        Logger.log(Type.INFO, msg1, msg2, msg3);
    }

    public static void i(Object msg1, Object msg2, Object msg3, Object msg4) {
        Logger.log(Type.INFO, msg1, msg2, msg3, msg4);
    }

    public static void i(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5) {
        Logger.log(Type.INFO, msg1, msg2, msg3, msg4, msg5);
    }

    public static void i(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5, Object msg6) {
        Logger.log(Type.INFO, msg1, msg2, msg3, msg4, msg5, msg6);
    }

    public static void i(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5, Object msg6, Object msg7) {
        Logger.log(Type.INFO, msg1, msg2, msg3, msg4, msg5, msg6, msg7);
    }

    public static void i(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5, Object msg6, Object msg7, Object msg8) {
        Logger.log(Type.INFO, msg1, msg2, msg3, msg4, msg5, msg6, msg7, msg8);
    }

    public static void e(Object msg) {
        Logger.log(Type.ERROR, msg);
    }

    public static void e(Object msg1, Object msg2) {
        Logger.log(Type.ERROR, msg1, msg2);
    }

    public static void e(Object msg1, Object msg2, Object msg3) {
        Logger.log(Type.ERROR, msg1, msg2, msg3);
    }

    public static void e(Object msg1, Object msg2, Object msg3, Object msg4) {
        Logger.log(Type.ERROR, msg1, msg2, msg3, msg4);
    }

    public static void e(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5) {
        Logger.log(Type.ERROR, msg1, msg2, msg3, msg4, msg5);
    }

    public static void e(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5, Object msg6) {
        Logger.log(Type.ERROR, msg1, msg2, msg3, msg4, msg5, msg6);
    }

    public static void e(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5, Object msg6, Object msg7) {
        Logger.log(Type.ERROR, msg1, msg2, msg3, msg4, msg5, msg6, msg7);
    }

    public static void e(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5, Object msg6, Object msg7, Object msg8) {
        Logger.log(Type.ERROR, msg1, msg2, msg3, msg4, msg5, msg6, msg7, msg8);
    }

    public static void v(Object msg) {
        Logger.log(Type.VERBOSE, msg);
    }

    public static void v(Object msg1, Object msg2) {
        Logger.log(Type.VERBOSE, msg1, msg2);
    }

    public static void v(Object msg1, Object msg2, Object msg3) {
        Logger.log(Type.VERBOSE, msg1, msg2, msg3);
    }

    public static void v(Object msg1, Object msg2, Object msg3, Object msg4) {
        Logger.log(Type.VERBOSE, msg1, msg2, msg3, msg4);
    }

    public static void v(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5) {
        Logger.log(Type.VERBOSE, msg1, msg2, msg3, msg4, msg5);
    }

    public static void v(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5, Object msg6) {
        Logger.log(Type.VERBOSE, msg1, msg2, msg3, msg4, msg5, msg6);
    }

    public static void v(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5, Object msg6, Object msg7) {
        Logger.log(Type.VERBOSE, msg1, msg2, msg3, msg4, msg5, msg6, msg7);
    }

    public static void v(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5, Object msg6, Object msg7, Object msg8) {
        Logger.log(Type.VERBOSE, msg1, msg2, msg3, msg4, msg5, msg6, msg7, msg8);
    }

    public static void d(Object msg) {
        Logger.log(Type.DEBUG, msg);
    }

    public static void d(Object msg1, Object msg2) {
        Logger.log(Type.DEBUG, msg1, msg2);
    }

    public static void d(Object msg1, Object msg2, Object msg3) {
        Logger.log(Type.DEBUG, msg1, msg2, msg3);
    }

    public static void d(Object msg1, Object msg2, Object msg3, Object msg4) {
        Logger.log(Type.DEBUG, msg1, msg2, msg3, msg4);
    }

    public static void d(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5) {
        Logger.log(Type.DEBUG, msg1, msg2, msg3, msg4, msg5);
    }

    public static void d(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5, Object msg6) {
        Logger.log(Type.DEBUG, msg1, msg2, msg3, msg4, msg5, msg6);
    }

    public static void d(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5, Object msg6, Object msg7) {
        Logger.log(Type.DEBUG, msg1, msg2, msg3, msg4, msg5, msg6, msg7);
    }

    public static void d(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5, Object msg6, Object msg7, Object msg8) {
        Logger.log(Type.DEBUG, msg1, msg2, msg3, msg4, msg5, msg6, msg7, msg8);
    }

    public static void w(Object msg) {
        Logger.log(Type.WARM, msg);
    }

    public static void w(Object msg1, Object msg2) {
        Logger.log(Type.WARM, msg1, msg2);
    }

    public static void w(Object msg1, Object msg2, Object msg3) {
        Logger.log(Type.WARM, msg1, msg2, msg3);
    }

    public static void w(Object msg1, Object msg2, Object msg3, Object msg4) {
        Logger.log(Type.WARM, msg1, msg2, msg3, msg4);
    }

    public static void w(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5) {
        Logger.log(Type.WARM, msg1, msg2, msg3, msg4, msg5);
    }

    public static void w(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5, Object msg6) {
        Logger.log(Type.WARM, msg1, msg2, msg3, msg4, msg5, msg6);
    }

    public static void w(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5, Object msg6, Object msg7) {
        Logger.log(Type.WARM, msg1, msg2, msg3, msg4, msg5, msg6, msg7);
    }

    public static void w(Object msg1, Object msg2, Object msg3, Object msg4, Object msg5, Object msg6, Object msg7, Object msg8) {
        Logger.log(Type.WARM, msg1, msg2, msg3, msg4, msg5, msg6, msg7, msg8);
    }

    private static void log(Type type, Object ... msgs) {
        StringBuilder log = new StringBuilder();
        for (Object msg : msgs) {
            log.append(msg.toString());
        }
        if (type == Type.WARM) {
            com.orhanobut.logger.Logger.w((String)log.toString(), (Object[])new Object[0]);
        } else if (type == Type.INFO) {
            com.orhanobut.logger.Logger.i((String)log.toString(), (Object[])new Object[0]);
        } else if (type == Type.VERBOSE) {
            com.orhanobut.logger.Logger.v((String)log.toString(), (Object[])new Object[0]);
        } else if (type == Type.DEBUG) {
            com.orhanobut.logger.Logger.d((Object)log.toString());
        } else if (type == Type.ERROR) {
            com.orhanobut.logger.Logger.e((String)log.toString(), (Object[])new Object[0]);
        }
    }

    public static void e(Throwable e) {
        com.orhanobut.logger.Logger.w((String)Logger.getThrowableString(e), (Object[])new Object[0]);
    }

    private static String getThrowableString(Throwable e) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        while (e != null) {
            e.printStackTrace(printWriter);
            e = e.getCause();
        }
        String text = ((Object)writer).toString();
        printWriter.close();
        return text;
    }

    public static void json(String json) {
        com.orhanobut.logger.Logger.json((String)json);
    }

    public static void xml(String xml) {
        com.orhanobut.logger.Logger.xml((String)xml);
    }

    static String getLogPath(Context context, String path) {
        String diskPath = path;
        if (TextUtils.isEmpty((CharSequence)path)) {
            File file;
            diskPath = context != null ? ((file = context.getExternalFilesDir(null)) != null ? file.getAbsolutePath() : Environment.getExternalStorageDirectory().getAbsolutePath()) : Environment.getExternalStorageDirectory().getAbsolutePath();
        }
        return diskPath + File.separatorChar + "logger";
    }

    private static enum Type {
        INFO,
        WARM,
        VERBOSE,
        DEBUG,
        ERROR;

    }

    public static class Builder {
        String tag = "WMS_LOGGER";
        boolean isDebug = false;
        int methodCount = 0;
        int methodOffset = 5;
        boolean showThreadInfo = false;
        boolean saveFile;
        Context context;
        String logPath;
        int saveLogCount = 7;
        boolean deleteOnLaunch;
        @SuppressLint(value={"SimpleDateFormat"})
        SimpleDateFormat logFileFormat = new SimpleDateFormat("yyyy-MM-dd");
        int maxFileSize = 0x100000;

        private Builder() {
        }

        @NonNull
        public Builder maxFileSize(int val) {
            this.maxFileSize = val;
            return this;
        }

        public Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder isDebug(boolean debug) {
            this.isDebug = debug;
            return this;
        }

        public Builder methodCount(int cout) {
            this.methodCount = cout;
            return this;
        }

        public Builder methodOffset(int cout) {
            this.methodOffset = cout;
            return this;
        }

        public Builder showThreadInfo(boolean showThreadInfo) {
            this.showThreadInfo = showThreadInfo;
            return this;
        }

        public Builder saveFile(boolean save) {
            this.saveFile = save;
            return this;
        }

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder logPath(String logPath) {
            this.logPath = logPath;
            return this;
        }

        public Builder deleteOnLaunch(boolean deleteOnLaunch) {
            this.deleteOnLaunch = deleteOnLaunch;
            return this;
        }

        public void build() {
            Logger.getInstance(this);
        }

        public void build(boolean reBuild) {
            mInstance = null;
            Logger.getInstance(this);
        }

        public Builder saveLogCount(int count) {
            this.saveLogCount = count;
            return this;
        }

        public Builder logFileFormat(SimpleDateFormat format) {
            this.logFileFormat = format;
            return this;
        }
    }
}

