/*
 * Decompiled with CFR 0.152.
 */
package com.wms.logger;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.orhanobut.logger.LogStrategy;
import com.wms.logger.MyFormatStrategy;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;

public class DiskLogStrategy
implements LogStrategy {
    @NonNull
    private final Handler handler;

    public DiskLogStrategy(@NonNull Handler handler) {
        this.handler = MyFormatStrategy.checkNotNull(handler);
    }

    public void log(int level, @Nullable String tag, @NonNull String message) {
        MyFormatStrategy.checkNotNull(message);
        this.handler.sendMessage(this.handler.obtainMessage(level, (Object)message));
    }

    static class WriteHandler
    extends Handler {
        @NonNull
        private final String folder;
        @SuppressLint(value={"SimpleDateFormat"})
        private SimpleDateFormat logFileFormat;
        private final int maxFileSize;

        WriteHandler(@NonNull Looper looper, @NonNull String folder, SimpleDateFormat logFileFormat, int maxFileSize) {
            super(MyFormatStrategy.checkNotNull(looper));
            this.folder = MyFormatStrategy.checkNotNull(folder);
            this.logFileFormat = logFileFormat;
            this.maxFileSize = maxFileSize;
        }

        public void handleMessage(@NonNull Message msg) {
            block4: {
                String content = (String)msg.obj;
                FileWriter fileWriter = null;
                File logFile = this.getLogFile(this.folder);
                try {
                    fileWriter = new FileWriter(logFile, true);
                    this.writeLog(fileWriter, content);
                    fileWriter.flush();
                    fileWriter.close();
                }
                catch (IOException e) {
                    if (fileWriter == null) break block4;
                    try {
                        fileWriter.flush();
                        fileWriter.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        private void writeLog(@NonNull FileWriter fileWriter, @NonNull String content) throws IOException {
            MyFormatStrategy.checkNotNull(fileWriter);
            MyFormatStrategy.checkNotNull(content);
            fileWriter.append(content);
        }

        private File getLogFile(@NonNull String folderName) {
            MyFormatStrategy.checkNotNull(folderName);
            File folder = new File(folderName, this.logFileFormat.format(System.currentTimeMillis()));
            if (!folder.exists()) {
                folder.mkdirs();
            }
            int newFileCount = 1;
            File existingFile = null;
            File newFile = new File(folder, String.format("log_%s.txt", newFileCount));
            while (newFile.exists()) {
                existingFile = newFile;
                newFile = new File(folder, String.format("log_%s.txt", ++newFileCount));
            }
            if (existingFile != null) {
                if (existingFile.length() >= (long)this.maxFileSize) {
                    return newFile;
                }
                return existingFile;
            }
            return newFile;
        }
    }
}

