/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.connect.request;

import com.proton.bluetooth.connect.listener.RequestMtuListener;
import com.proton.bluetooth.connect.request.BleRequest;
import com.proton.bluetooth.connect.response.BleGeneralResponse;

public class BleMtuRequest
extends BleRequest
implements RequestMtuListener {
    private int mMtu;

    public BleMtuRequest(int mtu, BleGeneralResponse response) {
        super(response);
        this.mMtu = mtu;
    }

    @Override
    public void processRequest() {
        switch (this.getCurrentStatus()) {
            case 0: {
                this.onRequestCompleted(-1);
                break;
            }
            case 2: {
                this.requestMtu();
                break;
            }
            case 19: {
                this.requestMtu();
                break;
            }
            default: {
                this.onRequestCompleted(-1);
            }
        }
    }

    private void requestMtu() {
        if (!this.requestMtu(this.mMtu)) {
            this.onRequestCompleted(-1);
        } else {
            this.startRequestTiming();
        }
    }

    @Override
    public void onMtuChanged(int mtu, int status) {
        this.stopRequestTiming();
        if (status == 0) {
            this.putIntExtra("extra.mtu", mtu);
            this.onRequestCompleted(0);
        } else {
            this.onRequestCompleted(-1);
        }
    }
}

