/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.beacon;

import com.proton.bluetooth.beacon.BeaconItem;
import com.proton.bluetooth.utils.ByteUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class BeaconParser {
    private byte[] bytes;
    private ByteBuffer mByteBuffer;

    public BeaconParser(BeaconItem item) {
        this(item.bytes);
    }

    public BeaconParser(byte[] bytes) {
        this.bytes = bytes;
        this.mByteBuffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
    }

    public void setPosition(int position) {
        this.mByteBuffer.position(position);
    }

    public int readByte() {
        return this.mByteBuffer.get() & 0xFF;
    }

    public int readShort() {
        return this.mByteBuffer.getShort() & 0xFFFF;
    }

    public boolean getBit(int n, int index) {
        return (n & 1 << index) != 0;
    }

    public static List<BeaconItem> parseBeacon(byte[] bytes) {
        BeaconItem item;
        ArrayList<BeaconItem> items = new ArrayList<BeaconItem>();
        for (int i = 0; i < bytes.length && (item = BeaconParser.parse(bytes, i)) != null; i += item.len + 1) {
            items.add(item);
        }
        return items;
    }

    private static BeaconItem parse(byte[] bytes, int startIndex) {
        int length;
        BeaconItem item = null;
        if (bytes.length - startIndex >= 2 && (length = bytes[startIndex]) > 0) {
            byte type = bytes[startIndex + 1];
            int firstIndex = startIndex + 2;
            if (firstIndex < bytes.length) {
                item = new BeaconItem();
                int endIndex = firstIndex + length - 2;
                if (endIndex >= bytes.length) {
                    endIndex = bytes.length - 1;
                }
                item.type = type & 0xFF;
                item.len = length;
                item.bytes = ByteUtils.getBytes(bytes, firstIndex, endIndex);
            }
        }
        return item;
    }
}

