/*
 * Decompiled with CFR 0.152.
 */
package com.sinping.iosdialog.dialog.widget.base;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.LinearLayout;
import com.nineoldandroids.animation.Animator;
import com.sinping.iosdialog.animation.BaseAnimatorSet;
import com.sinping.iosdialog.dialog.utils.StatusBarUtils;

public abstract class BaseDialog<T extends BaseDialog<T>>
extends Dialog {
    protected String TAG;
    protected Context context;
    protected DisplayMetrics dm;
    protected boolean cancel;
    protected float widthScale = 1.0f;
    protected float heightScale;
    private BaseAnimatorSet showAnim;
    private BaseAnimatorSet dismissAnim;
    protected LinearLayout ll_top;
    protected LinearLayout ll_control_height;
    private boolean isShowAnim;
    private boolean isDismissAnim;
    protected float maxHeight;

    public BaseDialog(Context context) {
        super(context);
        this.setDialogTheme();
        this.context = context;
        this.TAG = ((Object)((Object)this)).getClass().getSimpleName();
        Log.d((String)this.TAG, (String)"constructor");
    }

    private void setDialogTheme() {
        this.requestWindowFeature(1);
        this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.getWindow().addFlags(2);
    }

    public abstract View onCreateView();

    public abstract void setUiBeforShow();

    protected void onCreate(Bundle savedInstanceState) {
        Log.d((String)this.TAG, (String)"onCreate");
        this.dm = this.context.getResources().getDisplayMetrics();
        this.ll_top = new LinearLayout(this.context);
        this.ll_top.setGravity(17);
        this.ll_control_height = new LinearLayout(this.context);
        this.ll_control_height.setOrientation(1);
        this.ll_control_height.addView(this.onCreateView());
        this.ll_top.addView((View)this.ll_control_height);
        this.maxHeight = this.dm.heightPixels - StatusBarUtils.getHeight(this.context);
        this.setContentView((View)this.ll_top, new ViewGroup.LayoutParams(this.dm.widthPixels, (int)this.maxHeight));
        this.setCanceledOnTouchOutside(true);
        this.ll_top.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BaseDialog.this.cancel) {
                    BaseDialog.this.dismiss();
                }
            }
        });
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        Log.d((String)this.TAG, (String)"onAttachedToWindow");
        this.setUiBeforShow();
        int width = this.widthScale == 0.0f ? -2 : (int)((float)this.dm.widthPixels * this.widthScale);
        int height = this.heightScale == 0.0f ? -2 : (this.heightScale == 1.0f ? -1 : (int)(this.maxHeight * this.heightScale));
        this.ll_control_height.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, height));
        if (this.showAnim != null) {
            this.showAnim.listener(new BaseAnimatorSet.AnimatorListener(){

                @Override
                public void onAnimationStart(Animator animator) {
                    BaseDialog.this.isShowAnim = true;
                }

                @Override
                public void onAnimationRepeat(Animator animator) {
                }

                @Override
                public void onAnimationEnd(Animator animator) {
                    BaseDialog.this.isShowAnim = false;
                }

                @Override
                public void onAnimationCancel(Animator animator) {
                    BaseDialog.this.isShowAnim = false;
                }
            }).playOn((View)this.ll_control_height);
        } else {
            BaseAnimatorSet.reset((View)this.ll_control_height);
        }
    }

    public void setCanceledOnTouchOutside(boolean cancel) {
        this.cancel = cancel;
        super.setCanceledOnTouchOutside(cancel);
    }

    public void show() {
        Log.d((String)this.TAG, (String)"show");
        super.show();
    }

    protected void onStart() {
        super.onStart();
        Log.d((String)this.TAG, (String)"onStart");
    }

    protected void onStop() {
        super.onStop();
        Log.d((String)this.TAG, (String)"onStop");
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Log.d((String)this.TAG, (String)"onDetachedFromWindow");
    }

    public void dismiss() {
        Log.d((String)this.TAG, (String)"dismiss");
        if (this.dismissAnim != null) {
            this.dismissAnim.listener(new BaseAnimatorSet.AnimatorListener(){

                @Override
                public void onAnimationStart(Animator animator) {
                    BaseDialog.this.isDismissAnim = true;
                }

                @Override
                public void onAnimationRepeat(Animator animator) {
                }

                @Override
                public void onAnimationEnd(Animator animator) {
                    BaseDialog.this.isDismissAnim = false;
                    BaseDialog.this.superDismiss();
                }

                @Override
                public void onAnimationCancel(Animator animator) {
                    BaseDialog.this.isDismissAnim = false;
                    BaseDialog.this.superDismiss();
                }
            }).playOn((View)this.ll_control_height);
        } else {
            this.superDismiss();
        }
    }

    public void superDismiss() {
        super.dismiss();
    }

    public void show(int animStyle) {
        Window window = this.getWindow();
        window.setWindowAnimations(animStyle);
        this.show();
    }

    public T dimEnabled(boolean isDimEnabled) {
        if (isDimEnabled) {
            this.getWindow().addFlags(2);
        } else {
            this.getWindow().clearFlags(2);
        }
        return (T)((Object)this);
    }

    public T widthScale(float widthScale) {
        this.widthScale = widthScale;
        return (T)((Object)this);
    }

    public T heightScale(float heightScale) {
        this.heightScale = heightScale;
        return (T)((Object)this);
    }

    public T showAnim(BaseAnimatorSet showAnim) {
        this.showAnim = showAnim;
        return (T)((Object)this);
    }

    public T dismissAnim(BaseAnimatorSet dismissAnim) {
        this.dismissAnim = dismissAnim;
        return (T)((Object)this);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.isDismissAnim || this.isShowAnim) {
            return true;
        }
        return super.dispatchTouchEvent(ev);
    }

    public void onBackPressed() {
        if (this.isDismissAnim || this.isShowAnim) {
            return;
        }
        super.onBackPressed();
    }

    protected int dp2px(float dp) {
        float scale = this.context.getResources().getDisplayMetrics().density;
        return (int)(dp * scale + 0.5f);
    }
}

