/*
 * Decompiled with CFR 0.152.
 */
package com.sinping.iosdialog.dialog.widget;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LayoutAnimationController;
import android.view.animation.TranslateAnimation;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.sinping.iosdialog.dialog.entity.DialogMenuItem;
import com.sinping.iosdialog.dialog.listener.OnOperItemClickL;
import com.sinping.iosdialog.dialog.utils.CornerUtils;
import com.sinping.iosdialog.dialog.widget.base.BaseDialog;
import java.util.ArrayList;

public class NormalListDialog
extends BaseDialog {
    private ListView lv;
    private TextView tv_title;
    private float cornerRadius_DP = 5.0f;
    private int titleBgColor = Color.parseColor((String)"#303030");
    private String title = "\u63d0\u793a";
    private int titleTextColor = Color.parseColor((String)"#ffffff");
    private float titleTextSize_SP = 16.5f;
    private int lvBgColor = Color.parseColor((String)"#ffffff");
    private int dividerColor = -3355444;
    private float dividerHeight_DP = 0.8f;
    private int itemPressColor = Color.parseColor((String)"#ffcccccc");
    private int itemTextColor = Color.parseColor((String)"#303030");
    private float itemTextSize_SP = 15.0f;
    private int itemExtraLeft;
    private int itemExtraTop;
    private int itemExtraRight;
    private int itemExtraBottom;
    private boolean isTitleShow = true;
    private BaseAdapter adapter;
    private ArrayList<DialogMenuItem> contents = new ArrayList();
    private OnOperItemClickL onOperItemClickL;
    private LayoutAnimationController lac;

    public void setOnOperItemClickL(OnOperItemClickL onOperItemClickL) {
        this.onOperItemClickL = onOperItemClickL;
    }

    public NormalListDialog(Context context, ArrayList<DialogMenuItem> baseItems) {
        super(context);
        this.contents.addAll(baseItems);
        this.init();
    }

    public NormalListDialog(Context context, String[] items) {
        super(context);
        this.contents = new ArrayList();
        for (String item : items) {
            DialogMenuItem customBaseItem = new DialogMenuItem(item, 0);
            this.contents.add(customBaseItem);
        }
        this.init();
    }

    public NormalListDialog(Context context, BaseAdapter adapter) {
        super(context);
        this.adapter = adapter;
        this.init();
    }

    private void init() {
        this.widthScale(0.8f);
        TranslateAnimation animation = new TranslateAnimation(1, 2.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f);
        animation.setInterpolator((Interpolator)new DecelerateInterpolator());
        animation.setDuration(550L);
        this.lac = new LayoutAnimationController((Animation)animation, 0.12f);
        this.lac.setInterpolator((Interpolator)new DecelerateInterpolator());
    }

    @Override
    public View onCreateView() {
        LinearLayout ll_container = new LinearLayout(this.context);
        ll_container.setOrientation(1);
        this.tv_title = new TextView(this.context);
        this.tv_title.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.tv_title.setSingleLine(true);
        this.tv_title.setPadding(this.dp2px(18.0f), this.dp2px(10.0f), 0, this.dp2px(10.0f));
        ll_container.addView((View)this.tv_title);
        this.lv = new ListView(this.context);
        this.lv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.lv.setCacheColorHint(0);
        this.lv.setFadingEdgeLength(0);
        this.lv.setVerticalScrollBarEnabled(false);
        this.lv.setSelector((Drawable)new ColorDrawable(0));
        ll_container.addView((View)this.lv);
        return ll_container;
    }

    @Override
    public void setUiBeforShow() {
        float radius = this.dp2px(this.cornerRadius_DP);
        this.tv_title.setBackgroundDrawable(CornerUtils.cornerDrawable(this.titleBgColor, new float[]{radius, radius, radius, radius, 0.0f, 0.0f, 0.0f, 0.0f}));
        this.tv_title.setText((CharSequence)this.title);
        this.tv_title.setTextSize(2, this.titleTextSize_SP);
        this.tv_title.setTextColor(this.titleTextColor);
        this.tv_title.setVisibility(this.isTitleShow ? 0 : 8);
        this.lv.setDivider((Drawable)new ColorDrawable(this.dividerColor));
        this.lv.setDividerHeight(this.dp2px(this.dividerHeight_DP));
        if (this.isTitleShow) {
            this.lv.setBackgroundDrawable(CornerUtils.cornerDrawable(this.lvBgColor, new float[]{0.0f, 0.0f, 0.0f, 0.0f, radius, radius, radius, radius}));
        } else {
            this.lv.setBackgroundDrawable(CornerUtils.cornerDrawable(this.lvBgColor, radius));
        }
        if (this.adapter == null) {
            this.adapter = new ListDialogAdapter();
        }
        this.lv.setAdapter((ListAdapter)this.adapter);
        this.lv.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                if (NormalListDialog.this.onOperItemClickL != null) {
                    NormalListDialog.this.onOperItemClickL.onOperItemClick(parent, view, position, id);
                }
            }
        });
        this.lv.setLayoutAnimation(this.lac);
    }

    public NormalListDialog titleBgColor(int titleBgColor) {
        this.titleBgColor = titleBgColor;
        return this;
    }

    public NormalListDialog title(String title) {
        this.title = title;
        return this;
    }

    public NormalListDialog titleTextSize_SP(float titleTextSize_SP) {
        this.titleTextSize_SP = titleTextSize_SP;
        return this;
    }

    public NormalListDialog titleTextColor(int titleTextColor) {
        this.titleTextColor = titleTextColor;
        return this;
    }

    public NormalListDialog isTitleShow(boolean isTitleShow) {
        this.isTitleShow = isTitleShow;
        return this;
    }

    public NormalListDialog lvBgColor(int lvBgColor) {
        this.lvBgColor = lvBgColor;
        return this;
    }

    public NormalListDialog cornerRadius(float cornerRadius_DP) {
        this.cornerRadius_DP = cornerRadius_DP;
        return this;
    }

    public NormalListDialog dividerColor(int dividerColor) {
        this.dividerColor = dividerColor;
        return this;
    }

    public NormalListDialog dividerHeight(float dividerHeight_DP) {
        this.dividerHeight_DP = dividerHeight_DP;
        return this;
    }

    public NormalListDialog itemPressColor(int itemPressColor) {
        this.itemPressColor = itemPressColor;
        return this;
    }

    public NormalListDialog itemTextColor(int itemTextColor) {
        this.itemTextColor = itemTextColor;
        return this;
    }

    public NormalListDialog itemTextSize(float itemTextSize_SP) {
        this.itemTextSize_SP = itemTextSize_SP;
        return this;
    }

    public NormalListDialog setItemExtraPadding(int itemLeft, int itemTop, int itemRight, int itemBottom) {
        this.itemExtraLeft = this.dp2px(itemLeft);
        this.itemExtraTop = this.dp2px(itemTop);
        this.itemExtraRight = this.dp2px(itemRight);
        this.itemExtraBottom = this.dp2px(itemBottom);
        return this;
    }

    public NormalListDialog layoutAnimation(LayoutAnimationController lac) {
        this.lac = lac;
        return this;
    }

    class ListDialogAdapter
    extends BaseAdapter {
        ListDialogAdapter() {
        }

        public int getCount() {
            return NormalListDialog.this.contents.size();
        }

        public Object getItem(int position) {
            return null;
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            DialogMenuItem item = (DialogMenuItem)NormalListDialog.this.contents.get(position);
            LinearLayout ll_item = new LinearLayout(NormalListDialog.this.context);
            ll_item.setOrientation(0);
            ll_item.setGravity(16);
            ImageView iv_item = new ImageView(NormalListDialog.this.context);
            iv_item.setPadding(0, 0, NormalListDialog.this.dp2px(15.0f), 0);
            ll_item.addView((View)iv_item);
            TextView tv_item = new TextView(NormalListDialog.this.context);
            tv_item.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            tv_item.setSingleLine(true);
            tv_item.setTextColor(NormalListDialog.this.itemTextColor);
            tv_item.setTextSize(2, NormalListDialog.this.itemTextSize_SP);
            ll_item.addView((View)tv_item);
            float radius = NormalListDialog.this.dp2px(NormalListDialog.this.cornerRadius_DP);
            if (NormalListDialog.this.isTitleShow) {
                ll_item.setBackgroundDrawable((Drawable)CornerUtils.listItemSelector(radius, 0, NormalListDialog.this.itemPressColor, position == NormalListDialog.this.contents.size() - 1));
            } else {
                ll_item.setBackgroundDrawable((Drawable)CornerUtils.listItemSelector(radius, 0, NormalListDialog.this.itemPressColor, NormalListDialog.this.contents.size(), position));
            }
            int left = item.resId == 0 ? NormalListDialog.this.dp2px(18.0f) : NormalListDialog.this.dp2px(16.0f);
            int top = NormalListDialog.this.dp2px(10.0f);
            int right = 0;
            int bottom = NormalListDialog.this.dp2px(10.0f);
            ll_item.setPadding(left + NormalListDialog.this.itemExtraLeft, top + NormalListDialog.this.itemExtraTop, right + NormalListDialog.this.itemExtraRight, bottom + NormalListDialog.this.itemExtraBottom);
            iv_item.setImageResource(item.resId);
            tv_item.setText((CharSequence)item.operName);
            iv_item.setVisibility(item.resId == 0 ? 8 : 0);
            return ll_item;
        }
    }
}

