/*
 * Decompiled with CFR 0.152.
 */
package com.sinping.iosdialog.dialog.widget;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LayoutAnimationController;
import android.view.animation.TranslateAnimation;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.sinping.iosdialog.dialog.entity.DialogMenuItem;
import com.sinping.iosdialog.dialog.listener.OnOperItemClickL;
import com.sinping.iosdialog.dialog.utils.CornerUtils;
import com.sinping.iosdialog.dialog.widget.base.BottomBaseDialog;
import java.util.ArrayList;

public class ActionSheetDialog
extends BottomBaseDialog {
    private ListView lv;
    private TextView tv_title;
    private View v_line_title;
    private TextView tv_cancel;
    private float cornerRadius_DP = 5.0f;
    private int titleBgColor = Color.parseColor((String)"#ddffffff");
    private String title = "\u63d0\u793a";
    private float titleHeight = 48.0f;
    private int titleTextColor = Color.parseColor((String)"#8F8F8F");
    private float titleTextSize_SP = 17.5f;
    private int lvBgColor = Color.parseColor((String)"#ddffffff");
    private int dividerColor = Color.parseColor((String)"#D7D7D9");
    private float dividerHeight_DP = 0.8f;
    private int itemPressColor = Color.parseColor((String)"#ffcccccc");
    private int itemTextColor = Color.parseColor((String)"#44A2FF");
    private float itemTextSize_SP = 17.5f;
    private float itemHeight_DP = 48.0f;
    private boolean isTitleShow = true;
    private BaseAdapter adapter;
    private ArrayList<DialogMenuItem> contents = new ArrayList();
    private OnOperItemClickL onOperItemClickL;
    private LayoutAnimationController lac;

    public void setOnOperItemClickL(OnOperItemClickL onOperItemClickL) {
        this.onOperItemClickL = onOperItemClickL;
    }

    public ActionSheetDialog(Context context, ArrayList<DialogMenuItem> baseItems, View animateView) {
        super(context, animateView);
        this.contents.addAll(baseItems);
        this.init();
    }

    public ActionSheetDialog(Context context, String[] items, View animateView) {
        super(context, animateView);
        this.contents = new ArrayList();
        for (String item : items) {
            DialogMenuItem customBaseItem = new DialogMenuItem(item, 0);
            this.contents.add(customBaseItem);
        }
        this.init();
    }

    public ActionSheetDialog(Context context, BaseAdapter adapter, View animateView) {
        super(context, animateView);
        this.adapter = adapter;
        this.init();
    }

    private void init() {
        this.widthScale(0.95f);
        TranslateAnimation animation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 6.0f, 1, 0.0f);
        animation.setInterpolator((Interpolator)new DecelerateInterpolator());
        animation.setDuration(350L);
        animation.setStartOffset(150L);
        this.lac = new LayoutAnimationController((Animation)animation, 0.12f);
        this.lac.setInterpolator((Interpolator)new DecelerateInterpolator());
    }

    @Override
    public View onCreateView() {
        LinearLayout ll_container = new LinearLayout(this.context);
        ll_container.setOrientation(1);
        ll_container.setBackgroundColor(0);
        this.tv_title = new TextView(this.context);
        this.tv_title.setGravity(17);
        this.tv_title.setPadding(this.dp2px(10.0f), this.dp2px(5.0f), this.dp2px(10.0f), this.dp2px(5.0f));
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.topMargin = this.dp2px(20.0f);
        ll_container.addView((View)this.tv_title, (ViewGroup.LayoutParams)params);
        this.v_line_title = new View(this.context);
        ll_container.addView(this.v_line_title);
        this.lv = new ListView(this.context);
        this.lv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2, 1.0f));
        this.lv.setCacheColorHint(0);
        this.lv.setFadingEdgeLength(0);
        this.lv.setVerticalScrollBarEnabled(false);
        this.lv.setSelector((Drawable)new ColorDrawable(0));
        ll_container.addView((View)this.lv);
        this.tv_cancel = new TextView(this.context);
        this.tv_cancel.setGravity(17);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
        lp.topMargin = this.dp2px(7.0f);
        lp.bottomMargin = this.dp2px(7.0f);
        this.tv_cancel.setLayoutParams((ViewGroup.LayoutParams)lp);
        ll_container.addView((View)this.tv_cancel);
        return ll_container;
    }

    @Override
    public void setUiBeforShow() {
        float radius = this.dp2px(this.cornerRadius_DP);
        this.tv_title.setHeight(this.dp2px(this.titleHeight));
        this.tv_title.setBackground(CornerUtils.cornerDrawable(this.titleBgColor, new float[]{radius, radius, radius, radius, 0.0f, 0.0f, 0.0f, 0.0f}));
        this.tv_title.setText((CharSequence)this.title);
        this.tv_title.setTextSize(2, this.titleTextSize_SP);
        this.tv_title.setTextColor(this.titleTextColor);
        this.tv_title.setVisibility(this.isTitleShow ? 0 : 8);
        this.v_line_title.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, this.dp2px(this.dividerHeight_DP)));
        this.v_line_title.setBackgroundColor(this.dividerColor);
        this.v_line_title.setVisibility(this.isTitleShow ? 0 : 8);
        this.tv_cancel.setHeight(this.dp2px(this.itemHeight_DP));
        this.tv_cancel.setText((CharSequence)"\u53d6\u6d88");
        this.tv_cancel.setTextSize(2, this.itemTextSize_SP);
        this.tv_cancel.setTextColor(this.itemTextColor);
        this.tv_cancel.setBackground((Drawable)CornerUtils.listItemSelector(radius, this.lvBgColor, this.itemPressColor, 1, 0));
        this.tv_cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ActionSheetDialog.this.dismiss();
            }
        });
        this.lv.setDivider((Drawable)new ColorDrawable(this.dividerColor));
        this.lv.setDividerHeight(this.dp2px(this.dividerHeight_DP));
        if (this.isTitleShow) {
            this.lv.setBackground(CornerUtils.cornerDrawable(this.lvBgColor, new float[]{0.0f, 0.0f, 0.0f, 0.0f, radius, radius, radius, radius}));
        } else {
            this.lv.setBackground(CornerUtils.cornerDrawable(this.lvBgColor, radius));
        }
        if (this.adapter == null) {
            this.adapter = new ListDialogAdapter();
        }
        this.lv.setAdapter((ListAdapter)this.adapter);
        this.lv.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                if (ActionSheetDialog.this.onOperItemClickL != null) {
                    ActionSheetDialog.this.onOperItemClickL.onOperItemClick(parent, view, position, id);
                }
            }
        });
        this.lv.setLayoutAnimation(this.lac);
    }

    public ActionSheetDialog titleBgColor(int titleBgColor) {
        this.titleBgColor = titleBgColor;
        return this;
    }

    public ActionSheetDialog title(String title) {
        this.title = title;
        return this;
    }

    public ActionSheetDialog titleHeight(float titleHeight) {
        this.titleHeight = titleHeight;
        return this;
    }

    public ActionSheetDialog titleTextSize_SP(float titleTextSize_SP) {
        this.titleTextSize_SP = titleTextSize_SP;
        return this;
    }

    public ActionSheetDialog titleTextColor(int titleTextColor) {
        this.titleTextColor = titleTextColor;
        return this;
    }

    public ActionSheetDialog isTitleShow(boolean isTitleShow) {
        this.isTitleShow = isTitleShow;
        return this;
    }

    public ActionSheetDialog lvBgColor(int lvBgColor) {
        this.lvBgColor = lvBgColor;
        return this;
    }

    public ActionSheetDialog cornerRadius(float cornerRadius_DP) {
        this.cornerRadius_DP = cornerRadius_DP;
        return this;
    }

    public ActionSheetDialog dividerColor(int dividerColor) {
        this.dividerColor = dividerColor;
        return this;
    }

    public ActionSheetDialog dividerHeight(float dividerHeight_DP) {
        this.dividerHeight_DP = dividerHeight_DP;
        return this;
    }

    public ActionSheetDialog itemPressColor(int itemPressColor) {
        this.itemPressColor = itemPressColor;
        return this;
    }

    public ActionSheetDialog itemTextColor(int itemTextColor) {
        this.itemTextColor = itemTextColor;
        return this;
    }

    public ActionSheetDialog itemTextSize(float itemTextSize_SP) {
        this.itemTextSize_SP = itemTextSize_SP;
        return this;
    }

    public ActionSheetDialog itemHeight(float itemHeight_DP) {
        this.itemHeight_DP = itemHeight_DP;
        return this;
    }

    public ActionSheetDialog layoutAnimation(LayoutAnimationController lac) {
        this.lac = lac;
        return this;
    }

    class ListDialogAdapter
    extends BaseAdapter {
        ListDialogAdapter() {
        }

        public int getCount() {
            return ActionSheetDialog.this.contents.size();
        }

        public Object getItem(int position) {
            return null;
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            DialogMenuItem item = (DialogMenuItem)ActionSheetDialog.this.contents.get(position);
            LinearLayout ll_item = new LinearLayout(ActionSheetDialog.this.context);
            ll_item.setOrientation(0);
            ll_item.setGravity(16);
            ImageView iv_item = new ImageView(ActionSheetDialog.this.context);
            iv_item.setPadding(0, 0, ActionSheetDialog.this.dp2px(15.0f), 0);
            ll_item.addView((View)iv_item);
            TextView tv_item = new TextView(ActionSheetDialog.this.context);
            tv_item.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            tv_item.setSingleLine(true);
            tv_item.setGravity(17);
            tv_item.setTextColor(ActionSheetDialog.this.itemTextColor);
            tv_item.setTextSize(2, ActionSheetDialog.this.itemTextSize_SP);
            tv_item.setHeight(ActionSheetDialog.this.dp2px(ActionSheetDialog.this.itemHeight_DP));
            ll_item.addView((View)tv_item);
            float radius = ActionSheetDialog.this.dp2px(ActionSheetDialog.this.cornerRadius_DP);
            if (ActionSheetDialog.this.isTitleShow) {
                ll_item.setBackgroundDrawable((Drawable)CornerUtils.listItemSelector(radius, 0, ActionSheetDialog.this.itemPressColor, position == ActionSheetDialog.this.contents.size() - 1));
            } else {
                ll_item.setBackgroundDrawable((Drawable)CornerUtils.listItemSelector(radius, 0, ActionSheetDialog.this.itemPressColor, ActionSheetDialog.this.contents.size(), position));
            }
            iv_item.setImageResource(item.resId);
            tv_item.setText((CharSequence)item.operName);
            iv_item.setVisibility(item.resId == 0 ? 8 : 0);
            return ll_item;
        }
    }
}

