/*
 * Decompiled with CFR 0.152.
 */
package com.wman.crash.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.wman.crash.CustomActivityOnCrash;
import com.wman.crash.R;

public final class DefaultErrorActivity
extends Activity {
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.customactivityoncrash_default_error_activity);
        Button restartButton = (Button)this.findViewById(R.id.customactivityoncrash_error_activity_restart_button);
        final Class<? extends Activity> restartActivityClass = CustomActivityOnCrash.getRestartActivityClassFromIntent(this.getIntent());
        if (restartActivityClass != null) {
            restartButton.setText(R.string.customactivityoncrash_error_activity_restart_app);
            restartButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent((Context)DefaultErrorActivity.this, restartActivityClass);
                    CustomActivityOnCrash.restartApplicationWithIntent(DefaultErrorActivity.this, intent);
                }
            });
        } else {
            restartButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CustomActivityOnCrash.closeApplication(DefaultErrorActivity.this);
                }
            });
        }
        Button moreInfoButton = (Button)this.findViewById(R.id.customactivityoncrash_error_activity_more_info_button);
        if (CustomActivityOnCrash.isShowErrorDetailsFromIntent(this.getIntent())) {
            moreInfoButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AlertDialog dialog = new AlertDialog.Builder((Context)DefaultErrorActivity.this).setTitle(R.string.customactivityoncrash_error_activity_error_details_title).setMessage((CharSequence)CustomActivityOnCrash.getAllErrorDetailsFromIntent((Context)DefaultErrorActivity.this, DefaultErrorActivity.this.getIntent())).setPositiveButton(R.string.customactivityoncrash_error_activity_error_details_close, null).setNeutralButton(R.string.customactivityoncrash_error_activity_error_details_copy, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            DefaultErrorActivity.this.copyErrorToClipboard();
                            Toast.makeText((Context)DefaultErrorActivity.this, (int)R.string.customactivityoncrash_error_activity_error_details_copied, (int)0).show();
                        }
                    }).show();
                    TextView textView = (TextView)dialog.findViewById(16908299);
                    textView.setTextSize(0, DefaultErrorActivity.this.getResources().getDimension(R.dimen.customactivityoncrash_error_activity_error_details_text_size));
                }
            });
        } else {
            moreInfoButton.setVisibility(8);
        }
        int defaultErrorActivityDrawableId = CustomActivityOnCrash.getDefaultErrorActivityDrawableIdFromIntent(this.getIntent());
        ImageView errorImageView = (ImageView)this.findViewById(R.id.customactivityoncrash_error_activity_image);
        if (Build.VERSION.SDK_INT >= 21) {
            errorImageView.setImageDrawable(this.getResources().getDrawable(defaultErrorActivityDrawableId, this.getTheme()));
        } else {
            errorImageView.setImageDrawable(this.getResources().getDrawable(defaultErrorActivityDrawableId));
        }
    }

    private void copyErrorToClipboard() {
        String errorInformation = CustomActivityOnCrash.getAllErrorDetailsFromIntent((Context)this, this.getIntent());
        if (Build.VERSION.SDK_INT >= 11) {
            ClipboardManager clipboard = (ClipboardManager)this.getSystemService("clipboard");
            ClipData clip = ClipData.newPlainText((CharSequence)this.getString(R.string.customactivityoncrash_error_activity_error_details_clipboard_label), (CharSequence)errorInformation);
            clipboard.setPrimaryClip(clip);
        } else {
            android.text.ClipboardManager clipboard = (android.text.ClipboardManager)this.getSystemService("clipboard");
            clipboard.setText((CharSequence)errorInformation);
        }
    }
}

