/*
 * Decompiled with CFR 0.152.
 */
package com.wman.crash;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.util.Log;
import com.wman.crash.R;
import com.wman.crash.activity.DefaultErrorActivity;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@SuppressLint(value={"NewApi"})
public final class CustomActivityOnCrash {
    private static final String EXTRA_RESTART_ACTIVITY_CLASS = "cat.ereza.customactivityoncrash.EXTRA_RESTART_ACTIVITY_CLASS";
    private static final String EXTRA_SHOW_ERROR_DETAILS = "cat.ereza.customactivityoncrash.EXTRA_SHOW_ERROR_DETAILS";
    private static final String EXTRA_STACK_TRACE = "cat.ereza.customactivityoncrash.EXTRA_STACK_TRACE";
    private static final String EXTRA_IMAGE_DRAWABLE_ID = "cat.ereza.customactivityoncrash.EXTRA_IMAGE_DRAWABLE_ID";
    private static final String TAG = "CustomActivityOnCrash";
    private static final String INTENT_ACTION_ERROR_ACTIVITY = "cat.ereza.customactivityoncrash.ERROR";
    private static final String INTENT_ACTION_RESTART_ACTIVITY = "cat.ereza.customactivityoncrash.RESTART";
    private static final String CAOC_HANDLER_PACKAGE_NAME = "cat.ereza.customactivityoncrash";
    private static final String DEFAULT_HANDLER_PACKAGE_NAME = "com.android.internal.os";
    private static final int MAX_STACK_TRACE_SIZE = 131071;
    private static Application application;
    private static WeakReference<Activity> lastActivityCreated;
    private static boolean isInBackground;
    private static boolean launchErrorActivityWhenInBackground;
    private static boolean showErrorDetails;
    private static boolean enableAppRestart;
    private static int defaultErrorActivityDrawableId;
    private static Class<? extends Activity> errorActivityClass;
    private static Class<? extends Activity> restartActivityClass;

    public static void install(Context context) {
        try {
            if (context == null) {
                Log.e((String)TAG, (String)"Install failed: context is null!");
            } else {
                Thread.UncaughtExceptionHandler oldHandler;
                if (Build.VERSION.SDK_INT < 14) {
                    Log.w((String)TAG, (String)"CustomActivityOnCrash will be installed, but may not be reliable in API lower than 14");
                }
                if ((oldHandler = Thread.getDefaultUncaughtExceptionHandler()) != null && oldHandler.getClass().getName().startsWith(CAOC_HANDLER_PACKAGE_NAME)) {
                    Log.e((String)TAG, (String)"You have already installed CustomActivityOnCrash, doing nothing!");
                } else {
                    if (oldHandler != null && !oldHandler.getClass().getName().startsWith(DEFAULT_HANDLER_PACKAGE_NAME)) {
                        Log.e((String)TAG, (String)"IMPORTANT WARNING! You already have an UncaughtExceptionHandler, are you sure this is correct? If you use ACRA, Crashlytics or similar libraries, you must initialize them AFTER CustomActivityOnCrash! Installing anyway, but your original handler will not be called.");
                    }
                    application = (Application)context.getApplicationContext();
                    Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread thread, Throwable throwable) {
                            Log.e((String)CustomActivityOnCrash.TAG, (String)"App has crashed, executing CustomActivityOnCrash's UncaughtExceptionHandler", (Throwable)throwable);
                            if (errorActivityClass == null) {
                                errorActivityClass = CustomActivityOnCrash.guessErrorActivityClass((Context)application);
                            }
                            if (CustomActivityOnCrash.isStackTraceLikelyConflictive(throwable, errorActivityClass)) {
                                Log.e((String)CustomActivityOnCrash.TAG, (String)"Your application class or your error activity have crashed, the custom activity will not be launched!");
                            } else if (launchErrorActivityWhenInBackground || !isInBackground) {
                                Intent intent = new Intent((Context)application, errorActivityClass);
                                StringWriter sw = new StringWriter();
                                PrintWriter pw = new PrintWriter(sw);
                                throwable.printStackTrace(pw);
                                String stackTraceString = sw.toString();
                                if (stackTraceString.length() > 131071) {
                                    String disclaimer = " [stack trace too large]";
                                    stackTraceString = stackTraceString.substring(0, 131071 - disclaimer.length()) + disclaimer;
                                }
                                if (enableAppRestart && restartActivityClass == null) {
                                    restartActivityClass = CustomActivityOnCrash.guessRestartActivityClass((Context)application);
                                } else if (!enableAppRestart) {
                                    restartActivityClass = null;
                                }
                                intent.putExtra(CustomActivityOnCrash.EXTRA_STACK_TRACE, stackTraceString);
                                intent.putExtra(CustomActivityOnCrash.EXTRA_RESTART_ACTIVITY_CLASS, (Serializable)restartActivityClass);
                                intent.putExtra(CustomActivityOnCrash.EXTRA_SHOW_ERROR_DETAILS, showErrorDetails);
                                intent.putExtra(CustomActivityOnCrash.EXTRA_IMAGE_DRAWABLE_ID, defaultErrorActivityDrawableId);
                                intent.setFlags(0x10008000);
                                application.startActivity(intent);
                            }
                            Activity lastActivity = (Activity)lastActivityCreated.get();
                            if (lastActivity != null) {
                                lastActivity.finish();
                                lastActivityCreated.clear();
                            }
                            CustomActivityOnCrash.killCurrentProcess();
                        }
                    });
                    if (Build.VERSION.SDK_INT >= 14) {
                        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){
                            int currentlyStartedActivities = 0;

                            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                                if (activity.getClass() != errorActivityClass) {
                                    lastActivityCreated = new WeakReference<Activity>(activity);
                                }
                            }

                            public void onActivityStarted(Activity activity) {
                                ++this.currentlyStartedActivities;
                                isInBackground = this.currentlyStartedActivities == 0;
                            }

                            public void onActivityResumed(Activity activity) {
                            }

                            public void onActivityPaused(Activity activity) {
                            }

                            public void onActivityStopped(Activity activity) {
                                --this.currentlyStartedActivities;
                                isInBackground = this.currentlyStartedActivities == 0;
                            }

                            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                            }

                            public void onActivityDestroyed(Activity activity) {
                            }
                        });
                    }
                    Log.i((String)TAG, (String)"CustomActivityOnCrash has been installed.");
                }
            }
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)"An unknown error occurred while installing CustomActivityOnCrash, it may not have been properly initialized. Please report this as a bug if needed.", (Throwable)t);
        }
    }

    public static boolean isShowErrorDetailsFromIntent(Intent intent) {
        return intent.getBooleanExtra(EXTRA_SHOW_ERROR_DETAILS, true);
    }

    public static int getDefaultErrorActivityDrawableIdFromIntent(Intent intent) {
        return intent.getIntExtra(EXTRA_IMAGE_DRAWABLE_ID, R.drawable.customactivityoncrash_error_image);
    }

    public static String getStackTraceFromIntent(Intent intent) {
        return intent.getStringExtra(EXTRA_STACK_TRACE);
    }

    public static String getAllErrorDetailsFromIntent(Context context, Intent intent) {
        Date currentDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        String buildDateAsString = CustomActivityOnCrash.getBuildDateAsString(context, dateFormat);
        String versionName = CustomActivityOnCrash.getVersionName(context);
        String errorDetails = "";
        errorDetails = errorDetails + "Build version: " + versionName + " \n";
        errorDetails = errorDetails + "Build date: " + buildDateAsString + " \n";
        errorDetails = errorDetails + "Current date: " + dateFormat.format(currentDate) + " \n";
        errorDetails = errorDetails + "Device: " + CustomActivityOnCrash.getDeviceModelName() + " \n\n";
        errorDetails = errorDetails + "Stack trace:  \n";
        errorDetails = errorDetails + CustomActivityOnCrash.getStackTraceFromIntent(intent);
        return errorDetails;
    }

    public static Class<? extends Activity> getRestartActivityClassFromIntent(Intent intent) {
        Serializable serializedClass = intent.getSerializableExtra(EXTRA_RESTART_ACTIVITY_CLASS);
        if (serializedClass != null && serializedClass instanceof Class) {
            return (Class)serializedClass;
        }
        return null;
    }

    public static void restartApplicationWithIntent(Activity activity, Intent intent) {
        intent.addFlags(0x10008000);
        activity.finish();
        activity.startActivity(intent);
        CustomActivityOnCrash.killCurrentProcess();
    }

    public static void closeApplication(Activity activity) {
        activity.finish();
        CustomActivityOnCrash.killCurrentProcess();
    }

    public static boolean isLaunchErrorActivityWhenInBackground() {
        return launchErrorActivityWhenInBackground;
    }

    public static void setLaunchErrorActivityWhenInBackground(boolean launchErrorActivityWhenInBackground) {
        CustomActivityOnCrash.launchErrorActivityWhenInBackground = launchErrorActivityWhenInBackground;
    }

    public static boolean isShowErrorDetails() {
        return showErrorDetails;
    }

    public static void setShowErrorDetails(boolean showErrorDetails) {
        CustomActivityOnCrash.showErrorDetails = showErrorDetails;
    }

    public static int getDefaultErrorActivityDrawable() {
        return defaultErrorActivityDrawableId;
    }

    public static void setDefaultErrorActivityDrawable(int defaultErrorActivityDrawableId) {
        CustomActivityOnCrash.defaultErrorActivityDrawableId = defaultErrorActivityDrawableId;
    }

    public static boolean isEnableAppRestart() {
        return enableAppRestart;
    }

    public static void setEnableAppRestart(boolean enableAppRestart) {
        CustomActivityOnCrash.enableAppRestart = enableAppRestart;
    }

    public static Class<? extends Activity> getErrorActivityClass() {
        return errorActivityClass;
    }

    public static void setErrorActivityClass(Class<? extends Activity> errorActivityClass) {
        CustomActivityOnCrash.errorActivityClass = errorActivityClass;
    }

    public static Class<? extends Activity> getRestartActivityClass() {
        return restartActivityClass;
    }

    public static void setRestartActivityClass(Class<? extends Activity> restartActivityClass) {
        CustomActivityOnCrash.restartActivityClass = restartActivityClass;
    }

    private static boolean isStackTraceLikelyConflictive(Throwable throwable, Class<? extends Activity> activityClass) {
        do {
            StackTraceElement[] stackTrace;
            for (StackTraceElement element : stackTrace = throwable.getStackTrace()) {
                if ((!element.getClassName().equals("android.app.ActivityThread") || !element.getMethodName().equals("handleBindApplication")) && !element.getClassName().equals(activityClass.getName())) continue;
                return true;
            }
        } while ((throwable = throwable.getCause()) != null);
        return false;
    }

    private static String getBuildDateAsString(Context context, DateFormat dateFormat) {
        String buildDate;
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
            ZipFile zf = new ZipFile(ai.sourceDir);
            ZipEntry ze = zf.getEntry("classes.dex");
            long time = ze.getTime();
            buildDate = dateFormat.format(new Date(time));
            zf.close();
        }
        catch (Exception e) {
            buildDate = "Unknown";
        }
        return buildDate;
    }

    private static String getVersionName(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    private static String getDeviceModelName() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        if (model.startsWith(manufacturer)) {
            return CustomActivityOnCrash.capitalize(model);
        }
        return CustomActivityOnCrash.capitalize(manufacturer) + " " + model;
    }

    private static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char first = s.charAt(0);
        if (Character.isUpperCase(first)) {
            return s;
        }
        return Character.toUpperCase(first) + s.substring(1);
    }

    private static Class<? extends Activity> guessRestartActivityClass(Context context) {
        Class<? extends Activity> resolvedActivityClass = CustomActivityOnCrash.getRestartActivityClassWithIntentFilter(context);
        if (resolvedActivityClass == null) {
            resolvedActivityClass = CustomActivityOnCrash.getLauncherActivity(context);
        }
        return resolvedActivityClass;
    }

    private static Class<? extends Activity> getRestartActivityClassWithIntentFilter(Context context) {
        List resolveInfos = context.getPackageManager().queryIntentActivities(new Intent().setAction(INTENT_ACTION_RESTART_ACTIVITY), 64);
        if (resolveInfos != null && resolveInfos.size() > 0) {
            ResolveInfo resolveInfo = (ResolveInfo)resolveInfos.get(0);
            try {
                return Class.forName(resolveInfo.activityInfo.name);
            }
            catch (ClassNotFoundException e) {
                Log.e((String)TAG, (String)"Failed when resolving the restart activity class via intent filter, stack trace follows!", (Throwable)e);
            }
        }
        return null;
    }

    private static Class<? extends Activity> getLauncherActivity(Context context) {
        Intent intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        if (intent != null) {
            try {
                return Class.forName(intent.getComponent().getClassName());
            }
            catch (ClassNotFoundException e) {
                Log.e((String)TAG, (String)"Failed when resolving the restart activity class via getLaunchIntentForPackage, stack trace follows!", (Throwable)e);
            }
        }
        return null;
    }

    private static Class<? extends Activity> guessErrorActivityClass(Context context) {
        Class<? extends Activity> resolvedActivityClass = CustomActivityOnCrash.getErrorActivityClassWithIntentFilter(context);
        if (resolvedActivityClass == null) {
            resolvedActivityClass = DefaultErrorActivity.class;
        }
        return resolvedActivityClass;
    }

    private static Class<? extends Activity> getErrorActivityClassWithIntentFilter(Context context) {
        List resolveInfos = context.getPackageManager().queryIntentActivities(new Intent().setAction(INTENT_ACTION_ERROR_ACTIVITY), 64);
        if (resolveInfos != null && resolveInfos.size() > 0) {
            ResolveInfo resolveInfo = (ResolveInfo)resolveInfos.get(0);
            try {
                return Class.forName(resolveInfo.activityInfo.name);
            }
            catch (ClassNotFoundException e) {
                Log.e((String)TAG, (String)"Failed when resolving the error activity class via intent filter, stack trace follows!", (Throwable)e);
            }
        }
        return null;
    }

    private static void killCurrentProcess() {
        Process.killProcess((int)Process.myPid());
        System.exit(10);
    }

    static {
        lastActivityCreated = new WeakReference<Object>(null);
        isInBackground = false;
        launchErrorActivityWhenInBackground = true;
        showErrorDetails = true;
        enableAppRestart = true;
        defaultErrorActivityDrawableId = R.drawable.customactivityoncrash_error_image;
        errorActivityClass = null;
        restartActivityClass = null;
    }
}

