/*
 * Decompiled with CFR 0.152.
 */
package com.wlf.camerakit.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import com.wlf.camerakit.R;
import com.wlf.camerakit.utils.PreviewImpl;

@TargetApi(value=14)
public class TextureViewPreview
extends PreviewImpl {
    private final TextureView mTextureView;
    private int mDisplayOrientation;

    public TextureViewPreview(Context context, ViewGroup parent) {
        View view = View.inflate((Context)context, (int)R.layout.texture_view, (ViewGroup)parent);
        this.mTextureView = (TextureView)view.findViewById(R.id.texture_view);
        this.mTextureView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                TextureViewPreview.this.setSize(width, height);
                TextureViewPreview.this.dispatchSurfaceChanged();
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
                TextureViewPreview.this.setSize(width, height);
                TextureViewPreview.this.dispatchSurfaceChanged();
                TextureViewPreview.this.setTruePreviewSize(TextureViewPreview.this.mTrueWidth, TextureViewPreview.this.mTrueHeight);
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                TextureViewPreview.this.setSize(0, 0);
                return true;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            }
        });
    }

    @Override
    public void setCallback(PreviewImpl.Callback callback) {
        super.setCallback(callback);
    }

    @Override
    public Surface getSurface() {
        return new Surface(this.mTextureView.getSurfaceTexture());
    }

    @Override
    public View getView() {
        return this.mTextureView;
    }

    @Override
    public Class getOutputClass() {
        return SurfaceTexture.class;
    }

    @Override
    public void setDisplayOrientation(int displayOrientation) {
        this.mDisplayOrientation = displayOrientation;
    }

    @Override
    public boolean isReady() {
        return this.mTextureView.getSurfaceTexture() != null;
    }

    @Override
    public void dispatchSurfaceChanged() {
        super.dispatchSurfaceChanged();
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.mTextureView.getSurfaceTexture();
    }

    @Override
    @TargetApi(value=15)
    public void setTruePreviewSize(int width, int height) {
        super.setTruePreviewSize(width, height);
        if (this.mTextureView.getSurfaceTexture() != null) {
            this.mTextureView.getSurfaceTexture().setDefaultBufferSize(width, height);
        }
    }
}

