/*
 * Decompiled with CFR 0.152.
 */
package com.wlf.camerakit.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.Camera;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.wlf.camerakit.R;
import com.wlf.camerakit.utils.CameraPreview;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CameraActivity
extends Activity
implements View.OnClickListener {
    public static final int TYPE_IDCARD_FRONT = 1;
    public static final int TYPE_IDCARD_BACK = 2;
    public static final int TYPE_COMPANY_PORTRAIT = 3;
    public static final int TYPE_COMPANY_LANDSCAPE = 4;
    public static final int TYPE_BANKCARD_FRONT = 5;
    public static final int REQUEST_CODE = 19;
    public static final int RESULT_CODE = 20;
    private int type;
    private CameraPreview cameraPreview;
    private View containerView;
    private ImageView cropView;
    private ImageView flashImageView;
    private View optionView;
    private View resultView;
    Camera.ShutterCallback shutterCallback = new Camera.ShutterCallback(){

        public void onShutter() {
        }
    };
    Camera.PictureCallback rawCallback = new Camera.PictureCallback(){

        public void onPictureTaken(byte[] bytes, Camera camera) {
            Log.e((String)"--------", (String)(bytes + ""));
        }
    };
    Camera.PictureCallback jpegCallback = new Camera.PictureCallback(){

        public void onPictureTaken(final byte[] bytes, Camera camera) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        File originalFile = CameraActivity.this.getOriginalFile();
                        FileOutputStream originalFileOutputStream = new FileOutputStream(originalFile);
                        originalFileOutputStream.write(bytes);
                        originalFileOutputStream.close();
                        Bitmap bitmap = BitmapFactory.decodeFile((String)originalFile.getPath());
                        float left = (float)CameraActivity.this.cropView.getLeft() / (float)CameraActivity.this.cameraPreview.getWidth();
                        float top = ((float)CameraActivity.this.containerView.getTop() - (float)CameraActivity.this.cameraPreview.getTop()) / (float)CameraActivity.this.cameraPreview.getHeight();
                        float right = (float)CameraActivity.this.cropView.getRight() / (float)CameraActivity.this.cameraPreview.getWidth();
                        float bottom = (float)CameraActivity.this.containerView.getBottom() / (float)CameraActivity.this.cameraPreview.getHeight();
                        Bitmap cropBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)((int)(left * (float)bitmap.getWidth())), (int)((int)(top * (float)bitmap.getHeight())), (int)((int)((right - left) * (float)bitmap.getWidth())), (int)((int)((bottom - top) * (float)bitmap.getHeight())));
                        File cropFile = CameraActivity.this.getCropFile();
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(cropFile));
                        cropBitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
                        bos.flush();
                        bos.close();
                        CameraActivity.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                Log.e((String)"----------------------", (String)"\u62cd\u6444\u7ed3\u675f");
                                CameraActivity.this.cameraPreview.stopPreview();
                                CameraActivity.this.resultView.setVisibility(0);
                            }
                        });
                        return;
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    CameraActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            CameraActivity.this.optionView.setVisibility(0);
                            CameraActivity.this.cameraPreview.startPreview();
                            CameraActivity.this.cameraPreview.setEnabled(true);
                        }
                    });
                }
            }).start();
        }
    };

    public static void openCertificateCamera(Activity activity, int type) {
        Intent intent = new Intent((Context)activity, CameraActivity.class);
        intent.putExtra("type", type);
        activity.startActivityForResult(intent, 19);
    }

    public static String getResult(Intent data) {
        if (data != null) {
            return data.getStringExtra("result");
        }
        return "";
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRequestedOrientation(1);
        this.setContentView(R.layout.activity_camera);
        this.initView();
    }

    void initView() {
        this.cameraPreview = (CameraPreview)this.findViewById(R.id.camera_surface);
        this.cameraPreview.focus();
        float screenMinSize = Math.min(this.getResources().getDisplayMetrics().widthPixels, this.getResources().getDisplayMetrics().heightPixels);
        float maxSize = screenMinSize / 9.0f * 16.0f;
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams((int)screenMinSize, (int)maxSize);
        layoutParams.addRule(13);
        this.cameraPreview.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.containerView = this.findViewById(R.id.camera_crop_container);
        this.cropView = (ImageView)this.findViewById(R.id.camera_crop);
        float width = (int)((double)screenMinSize * 0.8);
        float height = (int)(width * 43.0f / 30.0f);
        LinearLayout.LayoutParams containerParams = new LinearLayout.LayoutParams(-1, (int)height);
        LinearLayout.LayoutParams cropParams = new LinearLayout.LayoutParams((int)width, (int)height);
        this.containerView.setLayoutParams((ViewGroup.LayoutParams)containerParams);
        this.cropView.setLayoutParams((ViewGroup.LayoutParams)cropParams);
        this.cropView.setImageResource(R.mipmap.camera_company);
        this.flashImageView = (ImageView)this.findViewById(R.id.camera_flash);
        this.optionView = this.findViewById(R.id.camera_option);
        this.resultView = this.findViewById(R.id.camera_result);
        this.cameraPreview.setOnClickListener(this);
        this.findViewById(R.id.camera_close).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.camera_take).setOnClickListener((View.OnClickListener)this);
        this.flashImageView.setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.camera_result_ok).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.camera_result_cancel).setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.camera_surface) {
            this.cameraPreview.focus();
        }
        if (id2 == R.id.camera_close) {
            this.finish();
        }
        if (id2 == R.id.camera_take) {
            this.takePhoto();
        }
        if (id2 == R.id.camera_flash) {
            boolean isFlashOn = this.cameraPreview.switchFlashLight();
            this.flashImageView.setImageResource(isFlashOn ? R.mipmap.camera_flash_on : R.mipmap.camera_flash_off);
        }
        if (id2 == R.id.camera_result_ok) {
            this.goBack();
        }
        if (id2 == R.id.camera_result_cancel) {
            this.optionView.setVisibility(0);
            this.cameraPreview.setEnabled(true);
            this.resultView.setVisibility(8);
            this.cameraPreview.startPreview();
        }
    }

    private void takePhoto() {
        this.optionView.setVisibility(8);
        this.cameraPreview.setEnabled(false);
        this.cameraPreview.takePhoto(this.shutterCallback, this.rawCallback, this.jpegCallback);
    }

    private File getOriginalFile() {
        return new File(this.getExternalCacheDir(), "picture.jpg");
    }

    private File getCropFile() {
        return new File(this.getExternalCacheDir(), "pictureCrop.jpg");
    }

    private void goBack() {
        this.type = this.getIntent().getExtras().getInt("type", 0);
        Intent intent = new Intent();
        intent.putExtra("result", this.getCropFile().getPath());
        intent.putExtra("type", this.type);
        this.setResult(20, intent);
        this.finish();
    }
}

