/*
 * Decompiled with CFR 0.152.
 */
package com.wlf.camerakit.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;

public class CameraTopRectView
extends View {
    private int panelWidth;
    private int panelHeght;
    private int viewWidth;
    private int viewHeight;
    public int rectWidth;
    public int rectHeght;
    private int rectTop;
    private int rectLeft;
    private int rectRight;
    private int rectBottom;
    private int lineLen;
    private int lineWidht;
    private int margin;
    private static final int LINE_WIDTH = 2;
    private static final int TOP_BAR_HEIGHT = 50;
    private static final int BOTTOM_BTN_HEIGHT = 66;
    private static final int LEFT_PADDING = 10;
    private static final int RIGHT_PADDING = 10;
    private static final String TIPS = "\u8bf7\u5c06\u8eab\u4efd\u8bc1\u653e\u5165\u5230\u65b9\u6846\u4e2d";
    private Paint linePaint;
    private Paint wordPaint;
    private Rect rect;
    private int baseline;

    public CameraTopRectView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Activity activity = (Activity)context;
        WindowManager manager = activity.getWindowManager();
        DisplayMetrics outMetrics = new DisplayMetrics();
        manager.getDefaultDisplay().getMetrics(outMetrics);
        this.panelWidth = outMetrics.widthPixels;
        this.viewHeight = this.panelHeght = outMetrics.heightPixels;
        this.viewWidth = this.panelWidth;
        this.rectHeght = this.viewHeight / 2;
        this.rectWidth = (int)((double)(this.rectHeght * 54) / 85.6);
        this.margin = (this.viewHeight - this.rectHeght) / 4;
        this.rectTop = (this.viewHeight - this.rectHeght) / 2 - this.margin;
        this.rectLeft = (this.viewWidth - this.rectWidth) / 2;
        this.rectBottom = this.rectTop + this.rectHeght;
        this.rectRight = this.rectLeft + this.rectWidth;
        this.lineLen = this.panelWidth / 8;
        this.linePaint = new Paint();
        this.linePaint.setAntiAlias(true);
        this.linePaint.setColor(-1);
        this.linePaint.setStyle(Paint.Style.STROKE);
        this.linePaint.setStrokeWidth(2.0f);
        this.linePaint.setAlpha(255);
        this.wordPaint = new Paint();
        this.wordPaint.setAntiAlias(true);
        this.wordPaint = new Paint(1);
        this.wordPaint.setStrokeWidth(3.0f);
        this.wordPaint.setTextSize(35.0f);
        this.rect = new Rect(this.rectLeft, this.rectTop, this.rectRight, this.rectBottom);
        Paint.FontMetricsInt fontMetrics = this.wordPaint.getFontMetricsInt();
        this.baseline = this.rect.top + (this.rect.bottom - this.rect.top - fontMetrics.bottom + fontMetrics.top) / 2 - fontMetrics.top;
        this.wordPaint.setTextAlign(Paint.Align.CENTER);
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.wordPaint.setColor(0);
        canvas.drawRect(this.rect, this.wordPaint);
        this.wordPaint.setColor(-1610612736);
        this.rect = new Rect(0, (this.viewHeight + this.rectHeght) / 2 - this.margin, this.viewWidth, this.viewHeight);
        canvas.drawRect(this.rect, this.wordPaint);
        this.rect = new Rect(0, 0, this.viewWidth, this.rectTop);
        canvas.drawRect(this.rect, this.wordPaint);
        this.rect = new Rect(0, (this.viewHeight - this.rectHeght) / 2 - this.margin, (this.viewWidth - this.rectWidth) / 2, (this.viewHeight + this.rectHeght) / 2 - this.margin);
        canvas.drawRect(this.rect, this.wordPaint);
        this.rect = new Rect(this.viewWidth - (this.viewWidth - this.rectWidth) / 2, (this.viewHeight - this.rectHeght) / 2 - this.margin, this.viewWidth, (this.viewHeight + this.rectHeght) / 2 - this.margin);
        canvas.drawRect(this.rect, this.wordPaint);
        canvas.drawLine((float)this.rectLeft, (float)this.rectTop, (float)this.rectRight, (float)this.rectTop, this.linePaint);
        canvas.drawLine((float)this.rectLeft, (float)this.rectTop, (float)this.rectLeft, (float)this.rectBottom, this.linePaint);
        canvas.drawLine((float)this.rectLeft, (float)this.rectBottom, (float)this.rectRight, (float)this.rectBottom, this.linePaint);
        canvas.drawLine((float)this.rectRight, (float)this.rectTop, (float)this.rectRight, (float)this.rectBottom, this.linePaint);
    }

    public int getRectLeft() {
        return this.rectLeft;
    }

    public int getRectTop() {
        return this.rectTop;
    }

    public int getRectRight() {
        return this.rectRight;
    }

    public int getRectBottom() {
        return this.rectBottom;
    }

    public int getRectWidth() {
        return this.rectWidth;
    }

    public int getRectHeght() {
        return this.rectHeght;
    }

    public int getViewWidth() {
        return this.viewWidth;
    }

    public int getViewHeight() {
        return this.viewHeight;
    }
}

