/*
 * Decompiled with CFR 0.152.
 */
package com.wlf.camerakit.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.util.Log;
import com.wlf.camerakit.listener.CameraListener;
import com.wlf.camerakit.utils.AspectRatio;
import com.wlf.camerakit.utils.CameraImpl;
import com.wlf.camerakit.utils.CommonAspectRatioFilter;
import com.wlf.camerakit.utils.ConstantMapper;
import com.wlf.camerakit.utils.PreviewImpl;
import com.wlf.camerakit.utils.Size;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

@TargetApi(value=21)
class Camera2
extends CameraImpl {
    private CameraDevice mCamera;
    private CameraCharacteristics mCameraCharacteristics;
    private CameraManager mCameraManager;
    private String mCameraId;
    private int mFacing;
    private Size mCaptureSize;
    private Size mPreviewSize;

    public Camera2(CameraListener callback, PreviewImpl preview, Context context) {
        super(callback, preview);
        preview.setCallback(new PreviewImpl.Callback(){

            @Override
            public void onSurfaceChanged() {
            }
        });
        this.mCameraManager = (CameraManager)context.getSystemService("camera");
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void setDisplayOrientation(int displayOrientation) {
    }

    @Override
    public void setFacing(int facing) {
        String[] ids;
        int internalFacing = new ConstantMapper.Facing(facing).map();
        if (internalFacing == -1) {
            return;
        }
        try {
            ids = this.mCameraManager.getCameraIdList();
        }
        catch (CameraAccessException e) {
            Log.e((String)"CameraKit", (String)e.toString());
            return;
        }
        if (ids.length == 0) {
            throw new RuntimeException("No camera available.");
        }
        if (this.mFacing == facing && this.isCameraOpened()) {
            this.stop();
            this.start();
        }
    }

    @Override
    public void setFlash(int flash) {
    }

    @Override
    public void setFocus(int focus) {
    }

    @Override
    public void setMethod(int method) {
    }

    @Override
    public void setZoom(int zoom) {
    }

    @Override
    public void setVideoQuality(int videoQuality) {
    }

    @Override
    public void captureImage() {
    }

    @Override
    public void startVideo() {
    }

    @Override
    public void endVideo() {
    }

    @Override
    public Size getCaptureResolution() {
        if (this.mCaptureSize == null && this.mCameraCharacteristics != null) {
            TreeSet<Size> sizes = new TreeSet<Size>();
            sizes.addAll(this.getAvailableCaptureResolutions());
            TreeSet<AspectRatio> aspectRatios = new CommonAspectRatioFilter(this.getAvailablePreviewResolutions(), this.getAvailableCaptureResolutions()).filter();
            AspectRatio targetRatio = aspectRatios.size() > 0 ? aspectRatios.last() : null;
            Iterator descendingSizes = sizes.descendingIterator();
            while (descendingSizes.hasNext() && this.mCaptureSize == null) {
                Size size = (Size)descendingSizes.next();
                if (targetRatio != null && !targetRatio.matches(size)) continue;
                this.mCaptureSize = size;
                break;
            }
        }
        return this.mCaptureSize;
    }

    @Override
    public Size getPreviewResolution() {
        if (this.mPreviewSize == null && this.mCameraCharacteristics != null) {
            TreeSet<Size> sizes = new TreeSet<Size>();
            sizes.addAll(this.getAvailablePreviewResolutions());
            TreeSet<AspectRatio> aspectRatios = new CommonAspectRatioFilter(this.getAvailablePreviewResolutions(), this.getAvailableCaptureResolutions()).filter();
            AspectRatio targetRatio = aspectRatios.size() > 0 ? aspectRatios.last() : null;
            Iterator descendingSizes = sizes.descendingIterator();
            while (descendingSizes.hasNext() && this.mPreviewSize == null) {
                Size size = (Size)descendingSizes.next();
                if (targetRatio != null && !targetRatio.matches(size)) continue;
                this.mPreviewSize = size;
                break;
            }
        }
        return this.mPreviewSize;
    }

    @Override
    public boolean isCameraOpened() {
        return this.mCamera != null;
    }

    private List<Size> getAvailableCaptureResolutions() {
        ArrayList<Size> output = new ArrayList<Size>();
        if (this.mCameraCharacteristics != null) {
            StreamConfigurationMap map = (StreamConfigurationMap)this.mCameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (map == null) {
                throw new IllegalStateException("Failed to get configuration map: " + this.mCameraId);
            }
            for (android.util.Size size : map.getOutputSizes(256)) {
                output.add(new Size(size.getWidth(), size.getHeight()));
            }
        }
        return output;
    }

    private List<Size> getAvailablePreviewResolutions() {
        ArrayList<Size> output = new ArrayList<Size>();
        if (this.mCameraCharacteristics != null) {
            StreamConfigurationMap map = (StreamConfigurationMap)this.mCameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (map == null) {
                throw new IllegalStateException("Failed to get configuration map: " + this.mCameraId);
            }
            for (android.util.Size size : map.getOutputSizes(this.mPreview.getOutputClass())) {
                output.add(new Size(size.getWidth(), size.getHeight()));
            }
        }
        return output;
    }
}

