/*
 * Decompiled with CFR 0.152.
 */
package com.wlf.camerakit.utils;

public class Rotation {
    private byte[] rotatedYuv;

    public Rotation(byte[] yuv, int width, int height, int rotation) {
        if (rotation == 0) {
            this.rotatedYuv = yuv;
        }
        if (rotation % 90 != 0 || rotation < 0 || rotation > 270) {
            throw new IllegalArgumentException("0 <= rotation < 360, rotation % 90 == 0");
        }
        byte[] output = new byte[yuv.length];
        int frameSize = width * height;
        boolean swap = rotation % 180 != 0;
        boolean xflip = rotation % 270 != 0;
        boolean yflip = rotation >= 180;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int yIn = j * width + i;
                int uIn = frameSize + (j >> 1) * width + (i & 0xFFFFFFFE);
                int vIn = uIn + 1;
                int wOut = swap ? height : width;
                int hOut = swap ? width : height;
                int iSwapped = swap ? j : i;
                int jSwapped = swap ? i : j;
                int iOut = xflip ? wOut - iSwapped - 1 : iSwapped;
                int jOut = yflip ? hOut - jSwapped - 1 : jSwapped;
                int yOut = jOut * wOut + iOut;
                int uOut = frameSize + (jOut >> 1) * wOut + (iOut & 0xFFFFFFFE);
                int vOut = uOut + 1;
                output[yOut] = (byte)(0xFF & yuv[yIn]);
                output[uOut] = (byte)(0xFF & yuv[uIn]);
                output[vOut] = (byte)(0xFF & yuv[vIn]);
            }
        }
        this.rotatedYuv = output;
    }

    public byte[] getYuv() {
        return this.rotatedYuv;
    }
}

