/*
 * Decompiled with CFR 0.152.
 */
package com.wlf.camerakit.utils;

import com.wlf.camerakit.kit.CameraKit;
import com.wlf.camerakit.utils.AspectRatio;
import com.wlf.camerakit.utils.Size;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

public class CommonAspectRatioFilter {
    private List<Size> mPreviewSizes;
    private List<Size> mCaptureSizes;

    public CommonAspectRatioFilter(List<Size> previewSizes, List<Size> captureSizes) {
        this.mPreviewSizes = previewSizes;
        this.mCaptureSizes = captureSizes;
    }

    public TreeSet<AspectRatio> filter() {
        HashSet<AspectRatio> previewAspectRatios = new HashSet<AspectRatio>();
        for (Size size : this.mPreviewSizes) {
            if (size.getWidth() < CameraKit.Internal.screenHeight || size.getHeight() < CameraKit.Internal.screenWidth) continue;
            previewAspectRatios.add(AspectRatio.of(size.getWidth(), size.getHeight()));
        }
        HashSet<AspectRatio> captureAspectRatios = new HashSet<AspectRatio>();
        for (Size size : this.mCaptureSizes) {
            captureAspectRatios.add(AspectRatio.of(size.getWidth(), size.getHeight()));
        }
        TreeSet<AspectRatio> treeSet = new TreeSet<AspectRatio>();
        for (AspectRatio aspectRatio : previewAspectRatios) {
            if (!captureAspectRatios.contains(aspectRatio)) continue;
            treeSet.add(aspectRatio);
        }
        return treeSet;
    }
}

